//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Effect2DAssetBuilder.h"
#include <Candera/Engine2D/Core/BitmapImage2D.h>
#include <Candera/Engine2D/Core/ProxyImage2D.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/DynamicItemCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/MetaInfoAssetBuilder.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>

namespace Candera {
    using namespace Diagnostics;
    using namespace MemoryManagement;
    using namespace MetaInfo;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<Effect2D>::ReadSecondPass(Effect2D& effect, LoaderContext& context)
        {
            Effect2DSetMetaInfo* effectSet2DMetaInfo = GetEffect2DSet();
            if (effectSet2DMetaInfo == 0) {
                FEATSTD_LOG_ERROR("Null EffectSet2DMetaInfo.");
                return false;
            }

            const Char* effectType = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicItemCanderaTypeName(context.handle));

            Effect2DMetaInfo* effectMetaInfo = effectSet2DMetaInfo->LookupItem(effectType);
            if (effectMetaInfo == 0) {
                FEATSTD_LOG_WARN("Null Effect2DMetaInfo for %s effect type.", effectType);
            }
            else {
                MetaInfoAssetBuilder<Effect2D, Effect2DPropertyMetaInfo, Effect2DMetaInfo> metaInfoReader(effect, *effectMetaInfo);
                if (!metaInfoReader.Read(context)) {
                    FEATSTD_LOG_ERROR("Asset error setting properties for effect %s.", effect.GetName());
                }
            }

            return true;
        }

        SharedPointer<Effect2D> AssetBuilderBase<SharedPointer<Effect2D> >::Create(LoaderContext& context)
        {
            Effect2DSetMetaInfo* effectSet2DMetaInfo = GetEffect2DSet();
            if (effectSet2DMetaInfo == 0) {
                FEATSTD_LOG_ERROR("Null EffectSet2DMetaInfo.");
                return SharedPointer<Effect2D>(0);
            }

            const Char* effectType = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicItemCanderaTypeName(context.handle));
            Effect2DMetaInfo* effectMetaInfo = effectSet2DMetaInfo->LookupItem(effectType);

            if (effectMetaInfo == 0) {
                FEATSTD_LOG_WARN("Null Effect2DMetaInfo for %s effect type.", effectType);
                return SharedPointer<Effect2D>(0);
            }

            return effectMetaInfo->Create();
        }
    }
}
