//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitmapImage2DAssetBuilder.h"
#include <FeatStd/Util/StaticObject.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProviderInternal.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/BitmapCffReader.h>

namespace Candera {
    using namespace MemoryManagement;
    using namespace Diagnostics;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<BitmapImage2D>::ReadFirstPass(BitmapImage2D& bitmapImage, LoaderContext& context)
        {
            bitmapImage.SetMemoryPool(static_cast<BitmapImage2D::MemoryPool>(CFFReader::GetBitmapMemoryPool(context.handle)));

            if (!CreateDependency(context, bitmapImage, context.id, SetBitmap)) {
                FEATSTD_LOG_WARN("Failed to associate Bitamp to BitmapImage2D " AssetIdLogStr, AssetIdLogArgs(context.id));
            }

            if (!bitmapImage.SetMipMappingEnabled(CFFReader::GetBitmapIsMipMappingEnabled(context.handle))) {
                FEATSTD_LOG_WARN("Set MipMapping-Enabled failed for BitmapImage2D " AssetIdLogStr ". The DeviceObject2D "
                    "might be already uploaded.", AssetIdLogArgs(context.id));
            }
            return true;
        }

        bool AssetReaderBase<BitmapImage2D>::SetBitmap(BitmapImage2D& bitmapImage, AssetId id, DependencyList* dependencyList, const DefaultAssetProvider* provider)
        {
            Bitmap::SharedPointer bitmap = provider->m_internal->m_bitmapProvider.Get(id, dependencyList);
            if (bitmap == 0) {
                FEATSTD_LOG_INFO("Requested Bitmap " AssetIdLogStr " is not found. Adding another asset partition that contains "
                    "it might be required.", AssetIdLogArgs(id));
                return false;
            }

            if (!bitmapImage.SetBitmap(bitmap)) {
                FEATSTD_LOG_WARN("Set Bitmap failed for BitmapImage2D " AssetIdLogStr ". The DeviceObject2D "
                    "might be already uploaded.", AssetIdLogArgs(id));
                return false;
            }

            return true;
        }

        SharedPointer<BitmapImage2D> AssetBuilderBase<SharedPointer<BitmapImage2D> >::Create(LoaderContext& /*context*/)
        {
            return BitmapImage2D::Create();
        }

    }
}
