//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AnimationPropertySetterFactory2D.h"
#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/Camera2D.h>
#include <Candera/Engine2D/Effects/Effect2D.h>
#include <Candera/Engine2D/AnimationPropertySetters/AlphaNode2DPropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Node2DBoundingRectanglePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Node2DClippingRectanglePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Camera2DViewportPropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Camera2DScissorRectanglePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DRotatePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DScalePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DTranslatePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/RenderingEnabledNode2DPropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/SnapToDevicePixelEnabled2DPropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DRelativeTranslatePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DRelativeScalePropertySetter.h>
#include <Candera/Engine2D/AnimationPropertySetters/Transformable2DRelativeRotatePropertySetter.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>

namespace Candera {
        namespace Internal {

            using namespace Animation;

            AssetProvider* AnimationPropertySetterFactory2D::m_assetProvider = 0;

            const Int32 c_ScaleXy = 100;
            const Int32 c_ScaleX = 101;
            const Int32 c_ScaleY = 102;

            const Int32 c_RotateZ = 200;

            const Int32 c_TranslateXy = 300;
            const Int32 c_TranslateX = 301;
            const Int32 c_TranslateY = 302;

            const Int32 c_IsRenderingEnabled = 400;

            const Int32 c_Alpha2D = 500;

            const Int32 c_IsSnapToDevicePixelEnabled = 600;

            const Int32 c_Camera2DViewport = 700;
            const Int32 c_Camera2DViewportLeft = 701;
            const Int32 c_Camera2DViewportTop = 702;
            const Int32 c_Camera2DViewportWidth = 703;
            const Int32 c_Camera2DViewportHeight = 704;

            const Int32 c_Camera2DScissorRectangle = 800;
            const Int32 c_Camera2DScissorRectangleLeft = 801;
            const Int32 c_Camera2DScissorRectangleTop = 802;
            const Int32 c_Camera2DScissorRectangleWidth = 803;
            const Int32 c_Camera2DScissorRectangleHeight = 804;

            const Int32 c_Node2DBoundingRectangle = 900;
            const Int32 c_Node2DBoundingRectangleLeft = 901;
            const Int32 c_Node2DBoundingRectangleTop = 902;
            const Int32 c_Node2DBoundingRectangleWidth = 903;
            const Int32 c_Node2DBoundingRectangleHeight = 904;
            
            const Int32 c_Node2DClippingRectangle = 1100;
            const Int32 c_Node2DClippingRectangleLeft = 1101;
            const Int32 c_Node2DClippingRectangleTop = 1102;
            const Int32 c_Node2DClippingRectangleWidth = 1103;
            const Int32 c_Node2DClippingRectangleHeight = 1104;

            static const PropertySetterAssociation propertySettersMapper[] = {
                { aps2dTranslate, 2, apcInvalid, c_TranslateXy },
                { aps2dTranslate, 1, apcX, c_TranslateX },
                { aps2dTranslate, 1, apcY, c_TranslateY },

                { aps2dScale, 2, apcInvalid, c_ScaleXy },
                { aps2dScale, 1, apcX, c_ScaleX },
                { aps2dScale, 1, apcY, c_ScaleY },

                { aps2dRotate, 1, apcDefault, c_RotateZ },

                { aps2dIsRenderingEnabled, 1, apcDefault, c_IsRenderingEnabled },

                { aps2dAlpha, 1, apcDefault, c_Alpha2D },

                { aps2dIsSnapToDevicePixelEnabled, 1, apcDefault, c_IsSnapToDevicePixelEnabled },

                { aps2dCamera2DViewport, 4, apcInvalid, c_Camera2DViewport },
                { aps2dCamera2DViewport, 1, apcLeft, c_Camera2DViewportLeft },
                { aps2dCamera2DViewport, 1, apcTop, c_Camera2DViewportTop },
                { aps2dCamera2DViewport, 1, apcWidth, c_Camera2DViewportWidth },
                { aps2dCamera2DViewport, 1, apcHeight, c_Camera2DViewportHeight },

                { aps2dCameraScissorRectangle, 4, apcInvalid, c_Camera2DScissorRectangle },
                { aps2dCameraScissorRectangle, 1, apcLeft, c_Camera2DScissorRectangleLeft },
                { aps2dCameraScissorRectangle, 1, apcTop, c_Camera2DScissorRectangleTop },
                { aps2dCameraScissorRectangle, 1, apcWidth, c_Camera2DScissorRectangleWidth },
                { aps2dCameraScissorRectangle, 1, apcHeight, c_Camera2DScissorRectangleHeight },

                { aps2dNode2DBoundingRectangle, 4, apcInvalid, c_Node2DBoundingRectangle},
                { aps2dNode2DBoundingRectangle, 1, apcLeft, c_Node2DBoundingRectangleLeft },
                { aps2dNode2DBoundingRectangle, 1, apcTop, c_Node2DBoundingRectangleTop },
                { aps2dNode2DBoundingRectangle, 1, apcWidth, c_Node2DBoundingRectangleWidth },
                { aps2dNode2DBoundingRectangle, 1, apcHeight, c_Node2DBoundingRectangleHeight },

                { aps2dNode2DClippingRectangle, 4, apcInvalid, c_Node2DClippingRectangle },
                { aps2dNode2DClippingRectangle, 1, apcLeft, c_Node2DClippingRectangleLeft },
                { aps2dNode2DClippingRectangle, 1, apcTop, c_Node2DClippingRectangleTop },
                { aps2dNode2DClippingRectangle, 1, apcWidth, c_Node2DClippingRectangleWidth },
                { aps2dNode2DClippingRectangle, 1, apcHeight, c_Node2DClippingRectangleHeight },

            };

            const Int32 numMapperEntries = sizeof(propertySettersMapper) / sizeof(PropertySetterAssociation);

            template<typename BaseTypeSPtr, typename DerivedType>
            BaseTypeSPtr CreateBasePropertySetter()
            {
                return DerivedType::Create();
            }

            struct BaseTransformable2DPropertySetterInfo {
                Int32 setterId;
                BaseTransformable2DPropertySetter::SharedPointer(*createFctPtr)();
            };

            static const BaseTransformable2DPropertySetterInfo baseTransformable2DPropertySetters[] = {
                { c_TranslateXy, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DTranslatePropertySetter> },
                { c_TranslateX, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DTranslateXPropertySetter> },
                { c_TranslateY, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DTranslateYPropertySetter> },
                { c_ScaleXy, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DScalePropertySetter> },
                { c_ScaleX, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DScaleXPropertySetter> },
                { c_ScaleY, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DScaleYPropertySetter> },
                { c_RotateZ, &CreateBasePropertySetter<BaseTransformable2DPropertySetter::SharedPointer, Transformable2DRotatePropertySetter> }
            };

            const Int32 tpsSize = sizeof(baseTransformable2DPropertySetters) / sizeof(BaseTransformable2DPropertySetterInfo);

            struct BaseNode2DPropertySetterInfo {
                Int32 setterId;
                BaseNode2DPropertySetter::SharedPointer(*createFctPtr)();
            };

            static const BaseNode2DPropertySetterInfo baseNode2DPropertySetters[] = {
                { c_IsRenderingEnabled, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, RenderingEnabledNode2DPropertySetter> },
                { c_Alpha2D, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, AlphaNode2DPropertySetter> },
                { c_IsSnapToDevicePixelEnabled, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, SnapToDevicePixelEnabled2DPropertySetter> },

                { c_Node2DBoundingRectangle, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DBoundingRectanglePropertySetter> },
                { c_Node2DBoundingRectangleLeft, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DBoundingRectangleLeftPropertySetter> },
                { c_Node2DBoundingRectangleTop, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DBoundingRectangleTopPropertySetter> },
                { c_Node2DBoundingRectangleWidth, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DBoundingRectangleWidthPropertySetter> },
                { c_Node2DBoundingRectangleHeight, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DBoundingRectangleHeightPropertySetter> },

                { c_Node2DClippingRectangle, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DClippingRectanglePropertySetter> },
                { c_Node2DClippingRectangleLeft, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DClippingRectangleLeftPropertySetter> },
                { c_Node2DClippingRectangleTop, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DClippingRectangleTopPropertySetter> },
                { c_Node2DClippingRectangleWidth, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DClippingRectangleWidthPropertySetter> },
                { c_Node2DClippingRectangleHeight, &CreateBasePropertySetter<BaseNode2DPropertySetter::SharedPointer, Node2DClippingRectangleHeightPropertySetter> }
            };

            const Int32 npsSize = sizeof(baseNode2DPropertySetters) / sizeof(BaseNode2DPropertySetterInfo);

            struct BaseCamera2DPropertySetterInfo {
                Int32 setterId;
                BaseCamera2DPropertySetter::SharedPointer(*createFctPtr)();
            };

            static const BaseCamera2DPropertySetterInfo baseCamera2DPropertySetters[] = {
                { c_Camera2DViewport, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DViewportPropertySetter> },
                { c_Camera2DViewportLeft, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DViewportLeftPropertySetter> },
                { c_Camera2DViewportTop, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DViewportTopPropertySetter> },
                { c_Camera2DViewportWidth, &CreateBasePropertySetter < BaseCamera2DPropertySetter::SharedPointer, Camera2DViewportWidthPropertySetter> },
                { c_Camera2DViewportHeight, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DViewportHeightPropertySetter> },

                { c_Camera2DScissorRectangle, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DScissorRectanglePropertySetter> },
                { c_Camera2DScissorRectangleLeft, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DScissorRectangleLeftPropertySetter> },
                { c_Camera2DScissorRectangleTop, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DScissorRectangleTopPropertySetter> },
                { c_Camera2DScissorRectangleWidth, &CreateBasePropertySetter < BaseCamera2DPropertySetter::SharedPointer, Camera2DScissorRectangleWidthPropertySetter> },
                { c_Camera2DScissorRectangleHeight, &CreateBasePropertySetter<BaseCamera2DPropertySetter::SharedPointer, Camera2DScissorRectangleHeightPropertySetter> }

            };

            const Int32 cpsSize = sizeof(baseCamera2DPropertySetters) / sizeof(BaseCamera2DPropertySetterInfo);

            struct BaseTransformable2DRelativePropertySetterInfo {
                Int32 setterId;
                BaseTransformable2DRelativePropertySetter::SharedPointer(*createFctPtr)();
            };

            static const BaseTransformable2DRelativePropertySetterInfo baseTransformable2DRelativePropertySetters[] = {
                { c_TranslateXy, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeTranslatePropertySetter> },
                { c_TranslateX, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeTranslateXPropertySetter> },
                { c_TranslateY, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeTranslateYPropertySetter> },
                { c_ScaleXy, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeScalePropertySetter> },
                { c_ScaleX, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeScaleXPropertySetter> },
                { c_ScaleY, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeScaleYPropertySetter> },
                { c_RotateZ, &CreateBasePropertySetter<BaseTransformable2DRelativePropertySetter::SharedPointer, Transformable2DRelativeRotatePropertySetter> }
            };

            const Int32 trpsSize = sizeof(baseTransformable2DRelativePropertySetters) / sizeof(BaseTransformable2DRelativePropertySetterInfo);

            static void SetupTransformable2DPropertySetter(Animation::AnimationPropertySetter::SharedPointer& propertySetter, Node2D* node, BaseTransformable2DPropertySetter::SharedPointer (*createFctPtr)())
            {
                BaseTransformable2DPropertySetter::SharedPointer tps = createFctPtr();
                if ((!tps.PointsToNull()) && ((0 != node))) {
                    tps->SetTransformable(node);
                    propertySetter = tps;
                }
            }

            static void SetupTransformable2DRelativePropertySetter(Animation::AnimationPropertySetter::SharedPointer& propertySetter, Node2D* node, BaseTransformable2DRelativePropertySetter::SharedPointer (*createFctPtr)())
            {
                BaseTransformable2DRelativePropertySetter::SharedPointer tps = createFctPtr();
                if ((!tps.PointsToNull()) && (0 != node)) {
                    tps->SetTransformable(node);
                    propertySetter = tps;
                }
            }

            static void SetupNode2DPropertySetter(Animation::AnimationPropertySetter::SharedPointer& propertySetter, Node2D* node, BaseNode2DPropertySetter::SharedPointer(*createFctPtr)())
            {
                BaseNode2DPropertySetter::SharedPointer nodePropertySetter = createFctPtr();
                if ((!nodePropertySetter.PointsToNull()) && ((0 != node))) {
                    nodePropertySetter->SetNode(node);
                    propertySetter = nodePropertySetter;
                }
            }

            static void SetupCamera2DPropertySetter(Animation::AnimationPropertySetter::SharedPointer& propertySetter, Node2D* node, BaseCamera2DPropertySetter::SharedPointer(*createFctPtr)())
            {
                BaseCamera2DPropertySetter::SharedPointer cameraPropertySetter = createFctPtr();
                Camera2D* camera = Dynamic_Cast<Camera2D*>(node);
                if ((!cameraPropertySetter.PointsToNull()) && ((0 != camera))) {
                    cameraPropertySetter->SetCamera(camera);
                    propertySetter = cameraPropertySetter;
                }
            }

            Animation::AnimationPropertySetter::SharedPointer AnimationPropertySetterFactory2D::CreateCorrespondingSetter(AnimationPropertySetterId propertyId, const Char* propertyName, const Vector<AnimatedPropertyChannels>& apcList, Candera::Internal::AssetId objectId, PropertySetterType setterType)
            {
                if (propertyId == aps2dEffectProperty) {
                    Effect2D::SharedPointer effect = m_assetProvider->GetEffect2DByAssetId(objectId);
                    if (effect != 0) {
                        return AnimationPropertySetterFactory::CreatePropertyMetaInfoSetter(effect->GetMetaInfo(), effect.GetPointerToSharedInstance(), propertyName, apcList);
                    }
                    else {
                        FEATSTD_LOG_ERROR("Could not find Effect " AssetIdLogStr " to create animation property setter!", AssetIdLogArgs(objectId));
                        return Animation::AnimationPropertySetter::SharedPointer(0);
                    }
                }

//                 if ((propertyId == aps2dCompositeProperty) && (objectPathInfo.GetReferencedItemType() == AotCompositeNode2D)) {
//                     CompositeGroup2D* compositeGroup = static_cast<CompositeGroup2D*>(m_assetProvider->GetObjectByPath(objectPathInfo));
//                     WidgetBase* widget = 0;
//                     const Char* widgetPropertyName = 0;
//                     if (m_assetProvider->GetComposite2DPropertyInfo(compositeGroup, propertyName, widget, widgetPropertyName)) {
//                         return AnimationPropertySetterFactory::CreatePropertyMetaInfoSetter(widget->GetMetaInfo(), widget, widgetPropertyName, apcList);
//                     }
//                 }

                Int32 setterId = FindApsClassId(propertyId, apcList);
                return CreateAnimationPropertySetterByClassId(setterId, propertyName, objectId, setterType);
            }

            Int32 AnimationPropertySetterFactory2D::FindApsClassId(AnimationPropertySetterId propertyId, const Vector<AnimatedPropertyChannels> &apcList)
            {
                Int32 foundIndex = -1;
                for (Int i = 0; i < numMapperEntries; i++) {
                    if (propertyId == propertySettersMapper[i].propertyId) {
                        if ((static_cast<Int32>(apcList.Size()) == propertySettersMapper[i].channelCount) && (apcList.Size() == 1)) {
                            if (apcList[0] == propertySettersMapper[i].channel0Id) {
                                foundIndex = i;
                                break;
                            }
                        }
                        else if ((static_cast<Int32>(apcList.Size()) == propertySettersMapper[i].channelCount) && (apcList.Size() > 1)) {
                            foundIndex = i;
                            break;
                        }
                        else {
                            //do nothing
                        }
                    }
                }
                if (foundIndex == -1) {
                    return -1;
                }

                return propertySettersMapper[foundIndex].setterClassId;
            }

            Animation::AnimationPropertySetter::SharedPointer AnimationPropertySetterFactory2D::CreateAnimationPropertySetterByClassId(Int32 setterId, const Char* /*propertyName*/, AssetId objectId, PropertySetterType setterType)
            {
                Animation::AnimationPropertySetter::SharedPointer nullPtr(0);

                if (setterId == -1) {
                    return nullPtr;
                }

                if (m_assetProvider == 0) {
                    FEATSTD_LOG_ERROR("No AssetProvider associated to the AnimationPropertySetterFactory!");
                    return nullPtr;
                }

                Node2D* node = m_assetProvider->GetNode2DByAssetId(objectId);
                if (node == 0) {
                    FEATSTD_LOG_ERROR("Could not find Node " AssetIdLogStr " to create animation property setter!", AssetIdLogArgs(objectId));
                    return nullPtr;
                }

                Animation::AnimationPropertySetter::SharedPointer propertySetter;

                switch (setterType) {
                    case pstAbsolute: {
                           for (Int i = 0; i < tpsSize; ++i) {
                               if (baseTransformable2DPropertySetters[i].setterId == setterId) {
                                   SetupTransformable2DPropertySetter(propertySetter, node, baseTransformable2DPropertySetters[i].createFctPtr);
                                   break;
                               }
                           }

                           if (!propertySetter.PointsToNull()) {
                               return propertySetter;
                           }

                           for (Int i = 0; i < npsSize; ++i) {
                               if (baseNode2DPropertySetters[i].setterId == setterId) {
                                   SetupNode2DPropertySetter(propertySetter, node, baseNode2DPropertySetters[i].createFctPtr);
                                   break;
                               }
                           }

                           if (!propertySetter.PointsToNull()) {
                               return propertySetter;
                           }

                           for (Int i = 0; i < cpsSize; ++i) {
                               if (baseCamera2DPropertySetters[i].setterId == setterId) {
                                   SetupCamera2DPropertySetter(propertySetter, node, baseCamera2DPropertySetters[i].createFctPtr);
                                   break;
                               }
                           }

                           if (!propertySetter.PointsToNull()) {
                               return propertySetter;
                           }
                        break;
                    }

                    case pstRelative: {
                       for (Int i = 0; i < trpsSize; ++i) {
                           if (baseTransformable2DRelativePropertySetters[i].setterId == setterId) {
                               SetupTransformable2DRelativePropertySetter(propertySetter, node, baseTransformable2DRelativePropertySetters[i].createFctPtr);
                               break;
                           }
                       }
                       if (!propertySetter.PointsToNull()) {
                           return propertySetter;
                       }
                       break;
                    }
                    default:
                        break;
                }

                return nullPtr;
            }
        }
}
