//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_TextSize_h)
#define Candera_TextSize_h

namespace Candera {
    namespace TextRendering {

/** @addtogroup CanderaTextEngine
 *  @{
 */
        
        /**
         * @brief Defines a 2D extent.
         */
        class TextSize {
            CANDERA_LINT_DECLARE_INITIALIZER_FUNCTION(Candera::TextRendering::TextSize::Set)
            public:
                /**
                 *  Constructor
                 */
                TextSize() :
                    m_width(0),
                    m_height(0)
                {
                }

                /**
                 *  Constructor with given parameters.
                 *  @param width  The width of this TextSize object.
                 *  @param height The height of this TextSize object.
                 */
                TextSize(Int16 width, Int16 height) :
                    m_width(width),
                    m_height(height)
                {
                }

                /**
                 *  Retrieves the width of this TextSize object.
                 *  @return The width of this TextSize object.
                 */
                Int16 GetWidth() const { return m_width; }

                /**
                 *  Sets the width of this TextSize object.
                 *  @param val The width of this TextSize object.
                 */
                void SetWidth(Int16 val) { m_width = val; }

                /**
                 *  Retrieves the height of this TextSize object.
                 *  @return The height of this TextSize object.
                 */
                Int16 GetHeight() const { return m_height; }

                /**
                 *  Sets the height of this TextSize object.
                 *  @param val The height of this TextSize object.
                 */
                void SetHeight(Int16 val) { m_height = val; }

                /**
                 *  Sets all the parameters.
                 *  @param width  The width of this TextSize object.
                 *  @param height The height of this TextSize object.
                 */
                void Set(Int16 width, Int16 height) {
                    m_width = width;
                    m_height = height;
                }

                bool operator==(const TextSize& other) const {
                    return (m_width == other.m_width) && (m_height == other.m_height);
                }

                bool operator!=(const TextSize& other) const
                {
                    return (m_width != other.m_width) || (m_height != other.m_height);
                }

            private:
                Int16 m_width;
                Int16 m_height;
        };

 /** @} */ // end of CanderaTextEngine

    }    // namespace TextRendering
}    // namespace Candera

#endif    // Candera_TextSize_h
