//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_NestedTextLayoutStrategy_h
#define Candera_TextEngine_NestedTextLayoutStrategy_h


#include <FeatStd/Container/Vector.h>
#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/TextLayoutStrategy.h>


namespace Candera {
    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
        *  @{
        */

        /**
        * @brief A strategy to call several strategies in a row
        * Priority of these strategies is the Insert-Order.
        * Possible advantage of this strategy in use:
        * There is a single responsible object for all the strategies.
        * So resource handling (if needed) could be done here.
        * The priority is easier comprehensible
        */
        class NestedTextLayoutStrategy : public TextLayoutStrategy {
        public:

            /**
            * Forwards OnInit to all added strategies.
            */
            virtual Action OnInit(Pass pass) override;

            /**
            * Forwards OnLineBreak to all added strategies.
            * @param textCursor is the current character.
            * @param type of linebreak
            */
            virtual Action OnLineBreak(const Char* textCursor, LineBreakType type) override;

            /**
            * Forwards OnGlyphProcessing to all added strategies.
            * @param textPosition is the current position within the text
            */
            virtual Action OnGlyphProcessing(TextPosition textPosition) override;

            /**
            * Adds a new strategy. Earlier added strategies have higher priority
            * @param strategy to add
            */
            void AddStrategy(TextLayoutStrategy* strategy);

        protected:
            FeatStd::Internal::Vector<TextLayoutStrategy*> m_strategies;///< attached strategies
        };
        /** @} */ // end of CanderaTextEngine

    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_NestedTextLayoutStrategy_h
