//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LineBreakLayoutStrategy.h"
#include "ITextLayoutStrategyDelegate.h"

namespace Candera {
    namespace TextRendering {


        LineBreakLayoutStrategy::LineBreakLayoutStrategy(ILayoutStrategyDelegate& context) : m_context(context)
        {

        }

        Candera::TextRendering::TextLayoutStrategy::Action LineBreakLayoutStrategy::OnInit(Pass)
        {
            return Continue;
        }

        Candera::TextRendering::TextLayoutStrategy::Action LineBreakLayoutStrategy::OnLineBreak(const Char* textCursor, LineBreakType type)
        {
            m_context.HandleNewLine(textCursor, type);
            return m_context.StopProcessing()?Break:Continue;
        }

        Candera::TextRendering::TextLayoutStrategy::Action LineBreakLayoutStrategy::OnGlyphProcessing(TextPosition textpos)
        {
            if (!m_context.SetGlyphProcessing(textpos)) {
                return Skip;
            }
            return Continue;
        }


    }
}
