//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_ITextLayoutStrategyDelegate_h
#define Candera_TextEngine_ITextLayoutStrategyDelegate_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/TextLayoutStrategy.h>

namespace Candera {
    namespace TextRendering {

        /** @addtogroup CanderaTextEngine
        *  @{
        */

        /**
        * @brief Interface is used to be able to delegate LayoutStrategy calls to another object (e.g. a Context)
        * and interact with this object. e.g. the strategy has its own way to notify skipping a glyph but
        * the context also wants to trigger a skip. It also notifies the context about specific informations
        */
        class ILayoutStrategyDelegate {
        public:
            /**
            * Delegates a new linebreak information to the interface implementer
            * @param textCursor is the current character.
            * @param lineBreakType type of linebreak
            */
            virtual void HandleNewLine(const Char* textCursor, TextLayoutStrategy::LineBreakType lineBreakType) = 0;
            /**
            * Asks whether the interface implementer wants to stop processing
            */
            virtual bool StopProcessing() = 0;
            /**
            * Delegates information about the next glyph which will be processed  to the interface implementer.
            * The implementer can give an own opinion whether the glyph should be skipped or not,
            * @param textpos is the current position within the text
            */
            virtual bool SetGlyphProcessing(TextPosition textpos) = 0;
        };
        /** @} */ // end of CanderaTextEngine

    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_ITextLayoutStrategyDelegate_h
