//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextMeasureContext.h"
#include <Candera/TextEngine/Style.h>

namespace Candera { namespace TextRendering {

    TextMeasureContext::TextMeasureContext(const TextRenderContext* reference) :
        m_reference(reference),
        m_next(0)
    {
    }

    const TextRect& TextMeasureContext::GetClipRect() const
    {
        return TextRect::GetMax();
    }

    void TextMeasureContext::Blit(Int16 x, Int16 y, const GlyphBitmap &glyph)
    {
        Measure(x, y, glyph);
        if (m_next != 0) {
            m_next->Blit(x, y, glyph);
        }
    }

    void TextMeasureContext::SkippedBlit(Int16 x, Int16 y, const GlyphBitmap &glyph)
    {
        SkippedMeasure(x, y, glyph);
        if (m_next != 0) {
            m_next->SkippedBlit(x, y, glyph);
        }
    }

    bool TextMeasureContext::IsRenderingEnabled() const
    {
        return false;
    }

    bool TextMeasureContext::IsCachingEnabled() const
    {
        return (m_reference != 0) ? m_reference->IsCachingEnabled() : true;
    }

    GlyphCacheAccess* TextMeasureContext::GetGlyphCacheAccess() const
    {
        return (m_reference != 0) ? m_reference->GetGlyphCacheAccess() : 0;
    }

    }    // namespace TextRendering
}    // namespace Candera
