//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_TextCoodinate_h)
#define Candera_TextCoodinate_h

#include <Candera/TextEngine/Types.h>

namespace Candera {

    namespace TextRendering {
    
/** @addtogroup CanderaTextEngine
 *  @{
 */

        /**
         *  @brief Defines a point in 2D space
         */
        class TextCoordinate {
            public:
                /**
                 *  Constructor
                 */
                TextCoordinate() :
                    m_xPos(0),
                    m_yPos(0)
                {
                }

                /**
                 *  Constructor with given parameters
                 *  @param x The x position
                 *  @param y The y position
                 */
                TextCoordinate(PixelPosition x, PixelPosition y) :
                    m_xPos(x),
                    m_yPos(y)
                {
                }

                /**
                 *  Retrieves the x position.
                 *  @return The x position
                 */
                PixelPosition GetX() const { return m_xPos; }

                /**
                 *  Sets the x position.
                 *  @param v The x position that is set.
                 */
                void SetX(PixelPosition v) { m_xPos = v; }

                /**
                 *  Retrieves the y position.
                 *  @return The y position
                 */
                PixelPosition GetY() const { return m_yPos; }

                /**
                 *  Sets the y position.
                 *  @param v The y position that is set.
                 */
                void SetY(PixelPosition v) { m_yPos = v; }

                /**
                 *  Sets the x and y position of the text.
                 *  @param x The x position that is set.
                 *  @param y The y position that is set.
                 */
                void Set(PixelPosition x, PixelPosition y) {
                    m_xPos = x;
                    m_yPos = y;
                }

                /**
                 *  Translates the text with the given parameters.
                 *  @param dx The delta x value
                 *  @param dy The delta y value
                 */
                void Translate(PixelPosition dx, PixelPosition dy) {
                    m_xPos += dx;
                    m_yPos += dy;
                }

                /**
                 *  Translates the text in x direction.
                 *  @param dx The delta x value
                 */
                void TranslateX(PixelPosition dx) {
                    m_xPos += dx;
                }

                /**
                 *  Translates the text in y direction.
                 *  @param dy The delta y value
                 */
                void TranslateY(PixelPosition dy) {
                    m_yPos += dy;
                }

            private:
                PixelPosition m_xPos;
                PixelPosition m_yPos;
        };

 /** @} */ // end of CanderaTextEngine
 
    }    // namespace TextRendering

}    // namespace Candera


#endif    // Candera_TextCoodinate_h
