//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "ShapingOptions.h"

namespace Candera {
    namespace TextRendering {


        ShapingOptions::ShapingOptions(const SharedStyle::SharedPointer& style, const Globalization::Culture::SharedPointer& culture, BidiBaseLevel::Enum bidiBaseLevel/* = BidiBaseLevel::Deprecated*/) : m_style(style), m_culture(culture), m_shaperType(ShaperType::Default),
            m_bidiBaseLevel(bidiBaseLevel)
        {

        }


        ShapingOptions::ShapingOptions(const SharedStyle::SharedPointer& style, BidiBaseLevel::Enum bidiBaseLevel/* = BidiBaseLevel::Deprecated*/) : m_style(style), m_culture(0), m_shaperType(ShaperType::Default), 
            m_bidiBaseLevel(bidiBaseLevel)
        {

        }


        ShapingOptions::ShapingOptions() : m_style(0), m_culture(0), m_shaperType(ShaperType::Default), m_bidiBaseLevel(BidiBaseLevel::Deprecated)
        {

        }

        void ShapingOptions::BindStyle(const SharedStyle::SharedPointer& style)
        {
            m_style = style;
        }

        const Candera::TextRendering::SharedStyle::SharedPointer& ShapingOptions::GetStyle() const
        {
            return m_style;
        }

        void ShapingOptions::BindCulture(const Globalization::Culture::SharedPointer& culture)
        {
            m_culture = culture;
        }

        const Candera::Globalization::Culture::SharedPointer& ShapingOptions::GetCulture() const
        {
            return m_culture;
        }

        Candera::TextRendering::ShaperType::Enum ShapingOptions::GetShaperType() const
        {
            return m_shaperType;
        }


        Candera::TextRendering::BidiBaseLevel::Enum ShapingOptions::GetBidiBaseLevel() const
        {
            return m_bidiBaseLevel;
        }

        void ShapingOptions::SetBidiBaseLevel(Candera::TextRendering::BidiBaseLevel::Enum val)
        {
            m_bidiBaseLevel = val;
        }

    }
}
