//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_MinimalPreprocessingContext_h)
#define Candera_MinimalPreprocessingContext_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/PreprocessingContext.h>
#include <Candera/TextEngine/TextRect.h>

#include <Candera/System/Container/ForwardIterator.h>
#include <FeatStd/Container/Vector.h>

namespace Candera { namespace TextRendering { 
    class Style;

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief PreprocessingContext with minimum collected data.
 */
class MinimalPreprocessingContext : public PreprocessingContext
{
public:
    /**
     * @brief Class used as interface for accessing preprocessed data.
     */
    class MinimalGlyphData : public PreprocessingContext::GlyphData
    {
        friend class MinimalPreprocessingContext;
    public:

        // Override functions from PreprocessingContext::GlyphData
        virtual FontIdentifier GetFontIdentifier() const;
        virtual GlyphIndex GetGlyphIndex() const;
        virtual TextPosition GetCharacterPosition() const;
        virtual PixelPosition2D GetPosition() const;
        virtual PixelPosition GetXAdvance() const;

    private:
        FontIdentifier m_fontIdentifier;
        GlyphIndex m_glyphIndex;
        TextPosition m_characterPosition;
        PixelPosition2D m_position;
        PixelPosition m_xAdvance;
    };
private:
    typedef FeatStd::Internal::Vector<MinimalGlyphData> DataContainer;
    typedef DataContainer::ConstIterator DataContainerIterator;

public:
    /**
     * @brief Type used for iterating over minimal the glyph information.
     */
    typedef ForwardIterator<DataContainerIterator> MinimalGlyphDataIterator;

    /**
     * Constructor.
     */
    explicit MinimalPreprocessingContext(const TextRenderContext* reference = 0);
    
    /**
     * Retrieve an interator usable with minimal glyph data.
     * @return An iterator.
     */
    MinimalGlyphDataIterator GetMinimalGlyphDataIterator() const;

    /**
     * Reserve a certain amount of memory for this object, to avoid reallocations during rendering.
     * @param size The amount of glyphs to reserve.
     */
    void Reserve(SizeType size);

    /**
     * Reset the size of the preprocessed data to 0.
     */
    void Clear();

private:
    // overrides functions from PreprocessingContext.
    virtual void Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph) final;
    virtual ReferenceIterator* GetReferenceIterator() const final;

    DataContainer m_container;
};

 /** @} */ // end of CanderaTextEngine

}// namespace TextRendering
}// namespace Candera

#endif// Candera_MinimalPreprocessingContext_h
