//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MinimalPreprocessingContext.h"
#include <Candera/TextEngine/Style.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/Internal/PreprocessingContextVectorIterator.h>

namespace Candera { namespace TextRendering {

FontIdentifier MinimalPreprocessingContext::MinimalGlyphData::GetFontIdentifier() const
{
    return m_fontIdentifier;
}
GlyphIndex MinimalPreprocessingContext::MinimalGlyphData::GetGlyphIndex() const
{
    return m_glyphIndex;
}
TextPosition MinimalPreprocessingContext::MinimalGlyphData::GetCharacterPosition() const
{
    return m_characterPosition;
}
PixelPosition2D MinimalPreprocessingContext::MinimalGlyphData::GetPosition() const
{
    return m_position;
}
PixelPosition MinimalPreprocessingContext::MinimalGlyphData::GetXAdvance() const
{
    return m_xAdvance;
}

MinimalPreprocessingContext::MinimalPreprocessingContext(const TextRenderContext* reference) :
    PreprocessingContext(reference),
    m_container()
{
}

MinimalPreprocessingContext::MinimalGlyphDataIterator MinimalPreprocessingContext::GetMinimalGlyphDataIterator() const
{
    return MinimalGlyphDataIterator(m_container.ConstBegin(), m_container.ConstEnd());
}

void MinimalPreprocessingContext::Reserve(SizeType size)
{
    static_cast<void>(m_container.Reserve(size));
}

void MinimalPreprocessingContext::Clear()
{
    m_container.Clear();
}

void MinimalPreprocessingContext::Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph)
{
    MinimalGlyphData storedGlyphData;

    storedGlyphData.m_fontIdentifier = glyph.fontIdentifier;
    storedGlyphData.m_glyphIndex = glyph.glyphIndex;
    storedGlyphData.m_characterPosition = glyph.characterPosition;
    storedGlyphData.m_position.x = x;
    storedGlyphData.m_position.y = y;
    storedGlyphData.m_xAdvance = glyph.xadvance;

    static_cast<void>(m_container.Add(storedGlyphData));
}

MinimalPreprocessingContext::ReferenceIterator* MinimalPreprocessingContext::GetReferenceIterator() const
{
    return Internal::PreprocessingContextVectorIterator<DataContainer, PreprocessingContext::ReferenceIterator>
        (m_container.ConstBegin(), m_container.ConstEnd()).Clone();
}

    }    // namespace TextRendering
}    // namespace Candera

