//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "Utf32IgnoreList.h"

#include <Candera/TextEngine/Internal/LookupTools.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            bool Utf32LookupComparer::More(Utf32 point, const Utf32* middle)
            {
                return point > *middle;
            }

            bool Utf32LookupComparer::Less(Utf32 point, const Utf32* middle)
            {
                return point < *middle;
            }

            bool Utf32IgnoreList::IsIgnoreCode(Utf32 unicode)
            {
                static const Utf32 c_classTable[] = {
                    10,     //b
                    13,     //b
                    28,     //b
                    29,     //b
                    30,     //b
                    133,    //b
                    8206,   //lrm (200E)
                    8207,   //rlm (300F)
                    8234,   //lre (202A)
                    8235,   //rle (202B)
                    8236,   //pdf
                    8237,   //lro (202D)
                    8238,   //rlo (202E)
                    8294,   //lri (2066)
                    8295   //rli (2067)
                };

                const UInt32 c_tableSize = sizeof(c_classTable) / sizeof(c_classTable[0]);

                const Utf32 c_commonInterval1Start = 30;
                const Utf32 c_commonInteval1End = 133;
                const Utf32 c_commonInterval2Start = 133;
                const Utf32 c_commonInterval2End = 8206;
                const Utf32 c_lastIgnored = c_classTable[c_tableSize - 1];

                //some very commonly used intervals should return faster
                if ((unicode > c_commonInterval1Start) && (unicode < c_commonInteval1End)) {
                    return false;
                }
                if ((unicode > c_commonInterval2Start) && (unicode < c_commonInterval2End)) {
                    return false;
                }
                if (unicode > c_lastIgnored) {
                    return false;
                }

                const Utf32* item = Internal::LookupTools::Find<const Utf32*, Utf32, Utf32LookupComparer>(c_classTable, c_classTable + c_tableSize, unicode);
                if (c_classTable + c_tableSize != item) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }
    }
}

