//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TrueTypeStyleMap.h"
#include <FeatStd/Util/String.h>


namespace Candera {
    namespace TextRendering {
        namespace Internal {
            const TrueTypeStyleMap::TrueTypeStyle TrueTypeStyleMap::m_styles[4] = 
            {
                {0x0, "Regular"},
                {0x1, "Bold"},
                {0x2, "Italic"},
                {0x3, "Bold Italic"}
            };

            FeatStd::String const& TrueTypeStyleMap::GetTrueTypeStyleName(UInt16 macStyle)
            {
                // no content check required - complete range is handled (0-3)
                UInt16 supportedStyle = (macStyle & static_cast<UInt16>(0x3));
                FEATSTD_DEBUG_ASSERT(supportedStyle == m_styles[supportedStyle].m_styleFlags);
                return m_styles[supportedStyle].m_styleName;
            }

        }
    }


}
