//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "TrueTypeCMapChooser.h"

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            TrueTypeCMapChooser& TrueTypeCMapChooser::GetInstance()
            {
                static TrueTypeCMapChooser s_instance;
                return s_instance;
            }

            void TrueTypeCMapChooser::SetCustomCMap(UInt16 platformID, UInt16 platformSpecificID)
            {
                m_customMap.platformID = platformID;
                m_customMap.platformSpecificID = platformSpecificID;
            }

            void TrueTypeCMapChooser::ResetCustomCMap()
            {
                // Windows, Unicode UCS-4
                m_customMap.platformID = 3;
                m_customMap.platformSpecificID = 10;
            }

            TrueTypeCMapChooser::CMapEntry const& TrueTypeCMapChooser::GetCMapEntry(SizeType idx) const
            {
                FEATSTD_DEBUG_ASSERT(idx < GetMapEntryCount());
                if (idx == 0) {
                    return m_customMap;
                }
                return m_CMapEntries[idx - 1];
            }

            SizeType TrueTypeCMapChooser::GetIndexOfMap(UInt16 platformID, UInt16 platformSpecificID) const
            {
                SizeType mapEntryCount = GetMapEntryCount();
                for (SizeType i = 0; i < mapEntryCount; i++) {
                    if (i > 0) {
                        CMapEntry const& entryRef = m_CMapEntries[i - 1];
                        if ((entryRef.platformID == platformID) && (entryRef.platformSpecificID == platformSpecificID)) {
                            return i;
                        }
                    }
                    else {
                        CMapEntry const& entryRef = m_customMap;
                        if ((entryRef.platformID == platformID) && (entryRef.platformSpecificID == platformSpecificID)) {
                            FEATSTD_DEBUG_ASSERT(i == 0);
                            return i;
                        }
                    }
                }
                return mapEntryCount;
            }

            TrueTypeCMapChooser::TrueTypeCMapChooser()
            {
                // Windows, Unicode UCS-4
                m_customMap.platformID = 3;
                m_customMap.platformSpecificID = 10;
            }

            SizeType TrueTypeCMapChooser::GetMapEntryCount() const
            {
                return 1 /* custom map */ + 7/*sizeof(TrueTypeCMapChooser::m_CMapEntries) / sizeof(CMapEntry)*/;
            }

            TrueTypeCMapChooser::CMapEntry const TrueTypeCMapChooser::m_CMapEntries[] =
            {
                {3, 10}, // Windows, Unicode UCS-4
                {3, 1},  // Windows, Unicode UCS-2
                {0, 4},  // Unicode 2.0 or later (preferred usage on OS X and iOS)
                {0, 3},  // Unicode (older version than 0,4)
                {0, 2},  // Unicode (older version than 0,3)
                {0, 1},  // Unicode (older version than 0,2)
                {0, 0}   // Unicode (older version than 0,1)
            };

        }
    }
}
