//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_TextPointer_h)
#define Candera_TextPointer_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {
            class ParserData;
/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 * TextPointer is used when processing text, to avoid using pointer
 * arithmetic.
 */
class TextPointer {
public:
    explicit TextPointer(TextPosition position) : m_position(position) {}

    const TChar* GetTChar(const TChar* start) const { return start + m_position;}
    TextPosition GetPosition() const { return m_position;}


    static TextPointer GetTCharPosition(const TChar* text, TextLength textLength, TextPointer start, TextPosition position);
    static TextPosition GetCodePointPosition(const TChar* text, TextPointer start, TextPointer position);


    TextLength operator- (const TextPointer& sub) const { return m_position - sub.m_position; }
    const TextPointer operator+ (TextLength length) const { return TextPointer(m_position + length); }
    const TextPointer& operator+= (TextLength length) { m_position += length; return *this; }

    bool operator== (const TextPointer& sub) const { return m_position == sub.m_position; }
    bool operator!= (const TextPointer& sub) const { return m_position != sub.m_position; }
    bool operator< (const TextPointer& sub) const { return m_position < sub.m_position; }
    bool operator<= (const TextPointer& sub) const { return m_position <= sub.m_position; }

    const TextPointer& operator= (const TextPointer& sub) { m_position = sub.m_position; return *this; }

private:
    TextPosition m_position;
};

 /** @} */ // end of CanderaTextEngine

        }     // namespace Internal
    }    // namespace TextRendering
}    // namespace Candera

#endif    // Candera_TextPointer_h
