//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_SimplifiedShaper_h)
#define Candera_SimplifiedShaper_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/TextEngine/TextRenderContext.h>
#include <Candera/TextEngine/Internal/Shaper.h>

namespace Candera {
    namespace TextRendering {
        class Font;

        namespace Internal {
            class GlyphRenderer;
            class ShaperInfo;

class SimplifiedShaper : public Shaper
{
public:
    virtual bool Initialize(const GlyphRenderer& glyphRenderer, const Font &font, const TChar* text, TextLength textSize, const ShaperInfo& info);
    virtual GlyphIndex GetGlyph() const;
    virtual TextPosition GetCharacterPosition() const;
    virtual void CorrectGlyphBitmap(GlyphBitmap& glyph) const;
    virtual void Advance();
    virtual bool IsEnd() const;

protected:
    SimplifiedShaper();
    virtual ~SimplifiedShaper();

    TextRenderContext::GlyphOrder GetGlyphOrder() const;

    struct UnicodeData
    {
        Utf32 codePoint; ///< Code point of the character.
        TextPosition characterPosition; ///< Position of the character within the text.
    };

    virtual bool InitializeUnicode(const TChar* text, TextLength textLength, const ShaperInfo& info) = 0;
    virtual UnicodeData GetUnicode() const = 0;
    virtual void AdvanceUnicode() = 0;
    virtual bool IsEndUnicode() const = 0;

    virtual GlyphBitmap::Direction GetDirection() const = 0;
    virtual bool IsInCorrectOrder() const = 0;

    virtual void CleanUp();
private:
    void UpdateNextIndex();
    void ReleaseReorderedData();

    struct GlyphData
    {
        GlyphIndex glyphIndex;
        TextPosition characterPosition;
    };
    TextRenderContext::GlyphOrder m_order;
    TextPosition m_reorderedDataEnd;
    GlyphData* m_reorderedData;

    GlyphData m_previousGlyph;
    GlyphData m_currentGlyph;
    GlyphData m_nextGlyph;

    const GlyphRenderer* m_glyphRenderer;
    const Font* m_font;
}; // class SimplifiedShaper 

        } // namespace Internal
    } // namespace TextRendering
} // namespace Candera

#endif// Candera_NullShaper_h
