//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################



#if !defined(Candera_ShaperInfo_h)
#define Candera_ShaperInfo_h

#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/TextEngine/TextRenderContext.h>

namespace Candera {
    namespace Globalization {
        class Culture;
    }
    namespace TextRendering {
        class ShapingOptions;
        namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief ShaperInfo is responsible to supply parameters to the Shaper.
 */
class ShaperInfo{
public:
    ShaperInfo(const ShapingOptions& shapingOptions, UInt8 direction, TextRenderContext::GlyphOrder order);

    GlyphBitmap::Direction GetDirection() const { return m_direction; }
    const Char* GetLocale() const { return m_locale; }
    TextRenderContext::GlyphOrder GetGlyphOrder() const { return m_order; }

private:
    GlyphBitmap::Direction m_direction;
    TextRenderContext::GlyphOrder m_order;
    const Char* m_locale;
}; // struct ShaperInfo

/** @} */ // end of CanderaTextEngine

        }// namespace Internal
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_ShaperInfo_h
