//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ShaperInfo.h"
#include <Candera/TextEngine/ShapingOptions.h>
#include <Candera/System/GlobalizationBase/Culture.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

ShaperInfo::ShaperInfo(const ShapingOptions& shapingOptions, UInt8 direction, TextRenderContext::GlyphOrder order) :
    m_direction(GlyphBitmap::Implicit),
    m_order(order),
    m_locale(0)
{
    const Globalization::Culture* culture = shapingOptions.GetCulture().GetPointerToSharedInstance();
    if (direction != 255) {
        m_direction = static_cast<GlyphBitmap::Direction>(direction);
    }
    else if (culture != 0){
        switch(culture->GetTextDirection()) {
            case Globalization::LeftToRight: m_direction = GlyphBitmap::LeftToRight; break;
            case Globalization::RightToLeft: m_direction = GlyphBitmap::RightToLeft; break;
            default:  m_direction = GlyphBitmap::Implicit; break;
        }
    }
    else {
        m_direction = GlyphBitmap::Implicit;
    }
    m_locale = (culture == 0) ? 0 : culture->GetLocale();
}

        }// namespace Internal
    }// namespace TextRendering
}// namespace Candera
