//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################




#if !defined(Candera_PlacementTextRenderContext_h)
#define Candera_PlacementTextRenderContext_h

#include <Candera/TextEngine/TextRenderContext.h>
#include <Candera/TextEngine/TextRenderer.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/Types.h>

namespace Candera { namespace TextRendering { namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief Defines an abstract render context and target for text rendering
 */
class PlacementTextRenderContext : public TextRenderContext {
public:
    PlacementTextRenderContext(Int16 places[]);

    virtual const TextRect& GetClipRect() const ;
    virtual void Blit(Int16 x, Int16 y, const GlyphBitmap &glyph) ;

    Int16* GetPlaces() { return m_places; }

private:
    Int16 *m_places;
};

 /** @} */ // end of CanderaTextEngine

}// namespace Internal
}// namespace TextRendering
}// namespace Candera

#endif// Candera_PlacementTextRenderContext_h
