//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "NullShaper.h"
#include <FeatStd/Util/PointerUtil.h>
#include <Candera/TextEngine/Internal/ShaperInfo.h>

namespace Candera { namespace TextRendering { namespace Internal { 

NullShaper::NullShaper() :
    m_isInCorrectOrder(true),
    m_text(0),
    m_direction(GlyphBitmap::LeftToRight),
    m_iterator(0, 0)
{
}

NullShaper::~NullShaper()
{
}

bool NullShaper::InitializeUnicode(const TChar* text, TextLength textLength, const ShaperInfo& info)
{
    m_text = text;
    m_iterator = FullBoundCodePointIterator(text, textLength);
    m_direction = (info.GetDirection() != GlyphBitmap::LeftToRight) ? GlyphBitmap::LeftToRight : GlyphBitmap::RightToLeft;
    m_isInCorrectOrder = (info.GetGlyphOrder() == TextRenderContext::OriginalGlyphOrder) ||
        (info.GetDirection() != GlyphBitmap::RightToLeft);
    return true;
}
NullShaper::UnicodeData NullShaper::GetUnicode() const
{
    FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: only const calls no side effect")
    UnicodeData data = {
        *m_iterator,
        static_cast<TextPosition>(FeatStd::Internal::PointerDiff(m_iterator.Pos(), m_text))
    };
    return data;
}

void NullShaper::AdvanceUnicode()
{
    static_cast<void>(m_iterator.Advance());
}
bool NullShaper::IsEndUnicode() const
{
    return (*m_iterator) == 0;
}

}}} // namespace
