//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################




#if !defined(Candera_MeasureTextRenderContext_h)
#define Candera_MeasureTextRenderContext_h

#include <Candera/TextEngine/TextRenderContext.h>
#include <Candera/TextEngine/MeasuringOptions.h>
#include <Candera/TextEngine/TextRect.h>

namespace Candera { namespace TextRendering { 
    class Style;

namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief Defines an abstract render context and target for text rendering
 */
class MeasureTextRenderContext : public TextRenderContext{
public:
    MeasureTextRenderContext(const MeasuringOptions& options, const Style& style, const TextRenderContext* referenceTextRenderContext);
    MeasureTextRenderContext(
        MeasuringOptions::FinalAdvance finalAdvanceOption,
        MeasuringOptions::TransversalSize transversalSizeOption,
        const Style& style,
        const TextRenderContext* referenceTextRenderContext);

    virtual const TextRect& GetClipRect() const { return TextRect::GetMax(); }
    virtual bool IsCachingEnabled() const { return m_referenceContext != 0 ? m_referenceContext->IsCachingEnabled() : true; }
    virtual GlyphCacheAccess* GetGlyphCacheAccess() const { return m_referenceContext != 0 ? m_referenceContext->GetGlyphCacheAccess() : 0; }
    virtual GlyphOrder GetGlyphOrder() const { return OriginalChunkOrder; }

    virtual void Blit(Int16 x, Int16 y, const GlyphBitmap &glyph);

    TextRect GetTextRectangle() const;

    virtual bool IsRenderingEnabled() const { return false; }

private:
    PixelPosition m_ascender;
    PixelPosition m_descender;
    
    const TextRenderContext* m_referenceContext;
    
    PixelPosition2D m_finalAdvance;
    TextRect m_box;

    MeasuringOptions::FinalAdvance m_finalAdvanceOption;
    MeasuringOptions::TransversalSize m_transversalSizeOption;
};

 /** @} */ // end of CanderaTextEngine

}// namespace Internal
}// namespace TextRendering
}// namespace Candera

#endif// Candera_MeasureTextRenderContext_h
