//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_TextEngine_Layouter_h)
#define Candera_TextEngine_Layouter_h

#include <Candera/TextEngine/TextCoordinate.h>
#include <Candera/TextEngine/TextSize.h>

namespace Candera {
    namespace Globalization {
        class Culture;
    }
    namespace TextRendering {
        class Style;
        class LayoutingOptions;
        class TextRect;

        namespace Internal {

/** @addtogroup CanderaTextEngine
 *  @{
 */
        class Layouter {
            public:
                Layouter(const Style& style);

                void Initialize(const LayoutingOptions& layoutingOptions, const Globalization::Culture* culture);
                void InitializeForMeasuring(const Layouter& layouter);

                void SetTextMeasurement(const TextRect& rect);
                void SetLineMeasurement(const TextRect& rect, Int16 wordBreakCount, bool forcedEnd);

                void AdvanceToNextLine();
                PixelPosition ComputeNextWordSpacing();

                PixelPosition GetGlyphSpacing() const { return m_glyphSpacing; }

                bool IsLineMatching(const TextRect& line) const;

                const TextCoordinate& GetCursorPosition() const { return m_cursorPosition; }
                Int16 GetWordBreakCount() const { return m_wordCount; }

                bool IsWordByWord() const { return m_isWordByWord; }
                bool IsWordWrapEnabled() const { return m_isWordWrapEnabled; }
                bool IsTextMeasurementNeeded() const;
                bool IsLineMeasurementNeeded() const;
        private:
                bool m_isWordByWord : 1;
                bool m_isWordWrapEnabled : 1;
                bool m_isRightToLeftDirection : 1;
                bool m_isOrientationRealignmentEnabled : 1;

                Int16 m_lineCount;
                Int16 m_wordCount;
                Int16 m_totalWordCount;

                PixelPosition m_ascender;
                PixelPosition m_lineSpacing;
                PixelPosition m_glyphSpacing;
                PixelPosition m_wordSpacing;
                PixelPosition m_horizontalAlignment;
                PixelPosition m_verticalAlignment;

                TextCoordinate m_cursorPosition;
                TextCoordinate m_offset;
                TextSize m_size;
        };

 /** @} */ // end of CanderaTextEngine
        }     // namespace Internal
    }    // namespace TextRendering
}    // namespace Candera

#endif    // Candera_TextEngine_Layouter_h
