//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbUnicode.h>
#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbInclude.h>

namespace Candera { namespace TextRendering { namespace Internal { namespace HarfBuzzShaper {
const HbUnicode::ScriptData HbUnicode::g_scriptTable[] = {
    {0, 64, HB_SCRIPT_COMMON},
    {65, 90, HB_SCRIPT_LATIN},
    {91, 96, HB_SCRIPT_COMMON},
    {97, 122, HB_SCRIPT_LATIN},
    {123, 169, HB_SCRIPT_COMMON},
    {170, 170, HB_SCRIPT_LATIN},
    {171, 185, HB_SCRIPT_COMMON},
    {186, 186, HB_SCRIPT_LATIN},
    {187, 191, HB_SCRIPT_COMMON},
    {192, 214, HB_SCRIPT_LATIN},
    {215, 215, HB_SCRIPT_COMMON},
    {216, 246, HB_SCRIPT_LATIN},
    {247, 247, HB_SCRIPT_COMMON},
    {248, 696, HB_SCRIPT_LATIN},
    {697, 735, HB_SCRIPT_COMMON},
    {736, 740, HB_SCRIPT_LATIN},
    {741, 745, HB_SCRIPT_COMMON},
    {746, 747, HB_SCRIPT_BOPOMOFO},
    {748, 767, HB_SCRIPT_COMMON},
    {768, 879, HB_SCRIPT_INHERITED},
    {880, 883, HB_SCRIPT_GREEK},
    {884, 884, HB_SCRIPT_COMMON},
    {885, 887, HB_SCRIPT_GREEK},
    {890, 893, HB_SCRIPT_GREEK},
    {894, 894, HB_SCRIPT_COMMON},
    {900, 900, HB_SCRIPT_GREEK},
    {901, 901, HB_SCRIPT_COMMON},
    {902, 902, HB_SCRIPT_GREEK},
    {903, 903, HB_SCRIPT_COMMON},
    {904, 906, HB_SCRIPT_GREEK},
    {908, 908, HB_SCRIPT_GREEK},
    {910, 929, HB_SCRIPT_GREEK},
    {931, 993, HB_SCRIPT_GREEK},
    {994, 1007, HB_SCRIPT_COPTIC},
    {1008, 1023, HB_SCRIPT_GREEK},
    {1024, 1156, HB_SCRIPT_CYRILLIC},
    {1157, 1158, HB_SCRIPT_INHERITED},
    {1159, 1319, HB_SCRIPT_CYRILLIC},
    {1329, 1366, HB_SCRIPT_ARMENIAN},
    {1369, 1375, HB_SCRIPT_ARMENIAN},
    {1377, 1415, HB_SCRIPT_ARMENIAN},
    {1417, 1417, HB_SCRIPT_COMMON},
    {1418, 1418, HB_SCRIPT_ARMENIAN},
    {1423, 1423, HB_SCRIPT_ARMENIAN},
    {1425, 1479, HB_SCRIPT_HEBREW},
    {1488, 1514, HB_SCRIPT_HEBREW},
    {1520, 1524, HB_SCRIPT_HEBREW},
    {1536, 1540, HB_SCRIPT_ARABIC},
    {1542, 1547, HB_SCRIPT_ARABIC},
    {1548, 1548, HB_SCRIPT_COMMON},
    {1549, 1562, HB_SCRIPT_ARABIC},
    {1563, 1563, HB_SCRIPT_COMMON},
    {1566, 1566, HB_SCRIPT_ARABIC},
    {1567, 1567, HB_SCRIPT_COMMON},
    {1568, 1599, HB_SCRIPT_ARABIC},
    {1600, 1600, HB_SCRIPT_COMMON},
    {1601, 1610, HB_SCRIPT_ARABIC},
    {1611, 1621, HB_SCRIPT_INHERITED},
    {1622, 1631, HB_SCRIPT_ARABIC},
    {1632, 1641, HB_SCRIPT_COMMON},
    {1642, 1647, HB_SCRIPT_ARABIC},
    {1648, 1648, HB_SCRIPT_INHERITED},
    {1649, 1756, HB_SCRIPT_ARABIC},
    {1757, 1757, HB_SCRIPT_COMMON},
    {1758, 1791, HB_SCRIPT_ARABIC},
    {1792, 1805, HB_SCRIPT_SYRIAC},
    {1807, 1866, HB_SCRIPT_SYRIAC},
    {1869, 1871, HB_SCRIPT_SYRIAC},
    {1872, 1919, HB_SCRIPT_ARABIC},
    {1920, 1969, HB_SCRIPT_THAANA},
    {1984, 2042, HB_SCRIPT_NKO},
    {2048, 2093, HB_SCRIPT_SAMARITAN},
    {2096, 2110, HB_SCRIPT_SAMARITAN},
    {2112, 2139, HB_SCRIPT_MANDAIC},
    {2142, 2142, HB_SCRIPT_MANDAIC},
    {2208, 2208, HB_SCRIPT_ARABIC},
    {2210, 2220, HB_SCRIPT_ARABIC},
    {2276, 2302, HB_SCRIPT_ARABIC},
    {2304, 2384, HB_SCRIPT_DEVANAGARI},
    {2385, 2386, HB_SCRIPT_INHERITED},
    {2387, 2403, HB_SCRIPT_DEVANAGARI},
    {2404, 2405, HB_SCRIPT_COMMON},
    {2406, 2423, HB_SCRIPT_DEVANAGARI},
    {2425, 2431, HB_SCRIPT_DEVANAGARI},
    {2433, 2435, HB_SCRIPT_BENGALI},
    {2437, 2444, HB_SCRIPT_BENGALI},
    {2447, 2448, HB_SCRIPT_BENGALI},
    {2451, 2472, HB_SCRIPT_BENGALI},
    {2474, 2480, HB_SCRIPT_BENGALI},
    {2482, 2482, HB_SCRIPT_BENGALI},
    {2486, 2489, HB_SCRIPT_BENGALI},
    {2492, 2500, HB_SCRIPT_BENGALI},
    {2503, 2504, HB_SCRIPT_BENGALI},
    {2507, 2510, HB_SCRIPT_BENGALI},
    {2519, 2519, HB_SCRIPT_BENGALI},
    {2524, 2525, HB_SCRIPT_BENGALI},
    {2527, 2531, HB_SCRIPT_BENGALI},
    {2534, 2555, HB_SCRIPT_BENGALI},
    {2561, 2563, HB_SCRIPT_GURMUKHI},
    {2565, 2570, HB_SCRIPT_GURMUKHI},
    {2575, 2576, HB_SCRIPT_GURMUKHI},
    {2579, 2600, HB_SCRIPT_GURMUKHI},
    {2602, 2608, HB_SCRIPT_GURMUKHI},
    {2610, 2611, HB_SCRIPT_GURMUKHI},
    {2613, 2614, HB_SCRIPT_GURMUKHI},
    {2616, 2617, HB_SCRIPT_GURMUKHI},
    {2620, 2620, HB_SCRIPT_GURMUKHI},
    {2622, 2626, HB_SCRIPT_GURMUKHI},
    {2631, 2632, HB_SCRIPT_GURMUKHI},
    {2635, 2637, HB_SCRIPT_GURMUKHI},
    {2641, 2641, HB_SCRIPT_GURMUKHI},
    {2649, 2652, HB_SCRIPT_GURMUKHI},
    {2654, 2654, HB_SCRIPT_GURMUKHI},
    {2662, 2677, HB_SCRIPT_GURMUKHI},
    {2689, 2691, HB_SCRIPT_GUJARATI},
    {2693, 2701, HB_SCRIPT_GUJARATI},
    {2703, 2705, HB_SCRIPT_GUJARATI},
    {2707, 2728, HB_SCRIPT_GUJARATI},
    {2730, 2736, HB_SCRIPT_GUJARATI},
    {2738, 2739, HB_SCRIPT_GUJARATI},
    {2741, 2745, HB_SCRIPT_GUJARATI},
    {2748, 2757, HB_SCRIPT_GUJARATI},
    {2759, 2761, HB_SCRIPT_GUJARATI},
    {2763, 2765, HB_SCRIPT_GUJARATI},
    {2768, 2768, HB_SCRIPT_GUJARATI},
    {2784, 2787, HB_SCRIPT_GUJARATI},
    {2790, 2801, HB_SCRIPT_GUJARATI},
    {2817, 2819, HB_SCRIPT_ORIYA},
    {2821, 2828, HB_SCRIPT_ORIYA},
    {2831, 2832, HB_SCRIPT_ORIYA},
    {2835, 2856, HB_SCRIPT_ORIYA},
    {2858, 2864, HB_SCRIPT_ORIYA},
    {2866, 2867, HB_SCRIPT_ORIYA},
    {2869, 2873, HB_SCRIPT_ORIYA},
    {2876, 2884, HB_SCRIPT_ORIYA},
    {2887, 2888, HB_SCRIPT_ORIYA},
    {2891, 2893, HB_SCRIPT_ORIYA},
    {2902, 2903, HB_SCRIPT_ORIYA},
    {2908, 2909, HB_SCRIPT_ORIYA},
    {2911, 2915, HB_SCRIPT_ORIYA},
    {2918, 2935, HB_SCRIPT_ORIYA},
    {2946, 2947, HB_SCRIPT_TAMIL},
    {2949, 2954, HB_SCRIPT_TAMIL},
    {2958, 2960, HB_SCRIPT_TAMIL},
    {2962, 2965, HB_SCRIPT_TAMIL},
    {2969, 2970, HB_SCRIPT_TAMIL},
    {2972, 2972, HB_SCRIPT_TAMIL},
    {2974, 2975, HB_SCRIPT_TAMIL},
    {2979, 2980, HB_SCRIPT_TAMIL},
    {2984, 2986, HB_SCRIPT_TAMIL},
    {2990, 3001, HB_SCRIPT_TAMIL},
    {3006, 3010, HB_SCRIPT_TAMIL},
    {3014, 3016, HB_SCRIPT_TAMIL},
    {3018, 3021, HB_SCRIPT_TAMIL},
    {3024, 3024, HB_SCRIPT_TAMIL},
    {3031, 3031, HB_SCRIPT_TAMIL},
    {3046, 3066, HB_SCRIPT_TAMIL},
    {3073, 3075, HB_SCRIPT_TELUGU},
    {3077, 3084, HB_SCRIPT_TELUGU},
    {3086, 3088, HB_SCRIPT_TELUGU},
    {3090, 3112, HB_SCRIPT_TELUGU},
    {3114, 3123, HB_SCRIPT_TELUGU},
    {3125, 3129, HB_SCRIPT_TELUGU},
    {3133, 3140, HB_SCRIPT_TELUGU},
    {3142, 3144, HB_SCRIPT_TELUGU},
    {3146, 3149, HB_SCRIPT_TELUGU},
    {3157, 3158, HB_SCRIPT_TELUGU},
    {3160, 3161, HB_SCRIPT_TELUGU},
    {3168, 3171, HB_SCRIPT_TELUGU},
    {3174, 3183, HB_SCRIPT_TELUGU},
    {3192, 3199, HB_SCRIPT_TELUGU},
    {3202, 3203, HB_SCRIPT_KANNADA},
    {3205, 3212, HB_SCRIPT_KANNADA},
    {3214, 3216, HB_SCRIPT_KANNADA},
    {3218, 3240, HB_SCRIPT_KANNADA},
    {3242, 3251, HB_SCRIPT_KANNADA},
    {3253, 3257, HB_SCRIPT_KANNADA},
    {3260, 3268, HB_SCRIPT_KANNADA},
    {3270, 3272, HB_SCRIPT_KANNADA},
    {3274, 3277, HB_SCRIPT_KANNADA},
    {3285, 3286, HB_SCRIPT_KANNADA},
    {3294, 3294, HB_SCRIPT_KANNADA},
    {3296, 3299, HB_SCRIPT_KANNADA},
    {3302, 3311, HB_SCRIPT_KANNADA},
    {3313, 3314, HB_SCRIPT_KANNADA},
    {3330, 3331, HB_SCRIPT_MALAYALAM},
    {3333, 3340, HB_SCRIPT_MALAYALAM},
    {3342, 3344, HB_SCRIPT_MALAYALAM},
    {3346, 3386, HB_SCRIPT_MALAYALAM},
    {3389, 3396, HB_SCRIPT_MALAYALAM},
    {3398, 3400, HB_SCRIPT_MALAYALAM},
    {3402, 3406, HB_SCRIPT_MALAYALAM},
    {3415, 3415, HB_SCRIPT_MALAYALAM},
    {3424, 3427, HB_SCRIPT_MALAYALAM},
    {3430, 3445, HB_SCRIPT_MALAYALAM},
    {3449, 3455, HB_SCRIPT_MALAYALAM},
    {3458, 3459, HB_SCRIPT_SINHALA},
    {3461, 3478, HB_SCRIPT_SINHALA},
    {3482, 3505, HB_SCRIPT_SINHALA},
    {3507, 3515, HB_SCRIPT_SINHALA},
    {3517, 3517, HB_SCRIPT_SINHALA},
    {3520, 3526, HB_SCRIPT_SINHALA},
    {3530, 3530, HB_SCRIPT_SINHALA},
    {3535, 3540, HB_SCRIPT_SINHALA},
    {3542, 3542, HB_SCRIPT_SINHALA},
    {3544, 3551, HB_SCRIPT_SINHALA},
    {3570, 3572, HB_SCRIPT_SINHALA},
    {3585, 3642, HB_SCRIPT_THAI},
    {3647, 3647, HB_SCRIPT_COMMON},
    {3648, 3675, HB_SCRIPT_THAI},
    {3713, 3714, HB_SCRIPT_LAO},
    {3716, 3716, HB_SCRIPT_LAO},
    {3719, 3720, HB_SCRIPT_LAO},
    {3722, 3722, HB_SCRIPT_LAO},
    {3725, 3725, HB_SCRIPT_LAO},
    {3732, 3735, HB_SCRIPT_LAO},
    {3737, 3743, HB_SCRIPT_LAO},
    {3745, 3747, HB_SCRIPT_LAO},
    {3749, 3749, HB_SCRIPT_LAO},
    {3751, 3751, HB_SCRIPT_LAO},
    {3754, 3755, HB_SCRIPT_LAO},
    {3757, 3769, HB_SCRIPT_LAO},
    {3771, 3773, HB_SCRIPT_LAO},
    {3776, 3780, HB_SCRIPT_LAO},
    {3782, 3782, HB_SCRIPT_LAO},
    {3784, 3789, HB_SCRIPT_LAO},
    {3792, 3801, HB_SCRIPT_LAO},
    {3804, 3807, HB_SCRIPT_LAO},
    {3840, 3911, HB_SCRIPT_TIBETAN},
    {3913, 3948, HB_SCRIPT_TIBETAN},
    {3953, 3991, HB_SCRIPT_TIBETAN},
    {3993, 4028, HB_SCRIPT_TIBETAN},
    {4030, 4044, HB_SCRIPT_TIBETAN},
    {4046, 4052, HB_SCRIPT_TIBETAN},
    {4053, 4056, HB_SCRIPT_COMMON},
    {4057, 4058, HB_SCRIPT_TIBETAN},
    {4096, 4255, HB_SCRIPT_MYANMAR},
    {4256, 4293, HB_SCRIPT_GEORGIAN},
    {4295, 4295, HB_SCRIPT_GEORGIAN},
    {4301, 4301, HB_SCRIPT_GEORGIAN},
    {4304, 4346, HB_SCRIPT_GEORGIAN},
    {4347, 4347, HB_SCRIPT_COMMON},
    {4348, 4351, HB_SCRIPT_GEORGIAN},
    {4352, 4607, HB_SCRIPT_HANGUL},
    {4608, 4680, HB_SCRIPT_ETHIOPIC},
    {4682, 4685, HB_SCRIPT_ETHIOPIC},
    {4688, 4694, HB_SCRIPT_ETHIOPIC},
    {4696, 4696, HB_SCRIPT_ETHIOPIC},
    {4698, 4701, HB_SCRIPT_ETHIOPIC},
    {4704, 4744, HB_SCRIPT_ETHIOPIC},
    {4746, 4749, HB_SCRIPT_ETHIOPIC},
    {4752, 4784, HB_SCRIPT_ETHIOPIC},
    {4786, 4789, HB_SCRIPT_ETHIOPIC},
    {4792, 4798, HB_SCRIPT_ETHIOPIC},
    {4800, 4800, HB_SCRIPT_ETHIOPIC},
    {4802, 4805, HB_SCRIPT_ETHIOPIC},
    {4808, 4822, HB_SCRIPT_ETHIOPIC},
    {4824, 4880, HB_SCRIPT_ETHIOPIC},
    {4882, 4885, HB_SCRIPT_ETHIOPIC},
    {4888, 4954, HB_SCRIPT_ETHIOPIC},
    {4957, 4988, HB_SCRIPT_ETHIOPIC},
    {4992, 5017, HB_SCRIPT_ETHIOPIC},
    {5024, 5108, HB_SCRIPT_CHEROKEE},
    {5120, 5759, HB_SCRIPT_CANADIAN_ABORIGINAL},
    {5760, 5788, HB_SCRIPT_OGHAM},
    {5792, 5866, HB_SCRIPT_RUNIC},
    {5867, 5869, HB_SCRIPT_COMMON},
    {5870, 5872, HB_SCRIPT_RUNIC},
    {5888, 5900, HB_SCRIPT_TAGALOG},
    {5902, 5908, HB_SCRIPT_TAGALOG},
    {5920, 5940, HB_SCRIPT_HANUNOO},
    {5941, 5942, HB_SCRIPT_COMMON},
    {5952, 5971, HB_SCRIPT_BUHID},
    {5984, 5996, HB_SCRIPT_TAGBANWA},
    {5998, 6000, HB_SCRIPT_TAGBANWA},
    {6002, 6003, HB_SCRIPT_TAGBANWA},
    {6016, 6109, HB_SCRIPT_KHMER},
    {6112, 6121, HB_SCRIPT_KHMER},
    {6128, 6137, HB_SCRIPT_KHMER},
    {6144, 6145, HB_SCRIPT_MONGOLIAN},
    {6146, 6147, HB_SCRIPT_COMMON},
    {6148, 6148, HB_SCRIPT_MONGOLIAN},
    {6149, 6149, HB_SCRIPT_COMMON},
    {6150, 6158, HB_SCRIPT_MONGOLIAN},
    {6160, 6169, HB_SCRIPT_MONGOLIAN},
    {6176, 6263, HB_SCRIPT_MONGOLIAN},
    {6272, 6314, HB_SCRIPT_MONGOLIAN},
    {6320, 6389, HB_SCRIPT_CANADIAN_ABORIGINAL},
    {6400, 6428, HB_SCRIPT_LIMBU},
    {6432, 6443, HB_SCRIPT_LIMBU},
    {6448, 6459, HB_SCRIPT_LIMBU},
    {6464, 6464, HB_SCRIPT_LIMBU},
    {6468, 6479, HB_SCRIPT_LIMBU},
    {6480, 6509, HB_SCRIPT_TAI_LE},
    {6512, 6516, HB_SCRIPT_TAI_LE},
    {6528, 6571, HB_SCRIPT_NEW_TAI_LUE},
    {6576, 6601, HB_SCRIPT_NEW_TAI_LUE},
    {6608, 6618, HB_SCRIPT_NEW_TAI_LUE},
    {6622, 6623, HB_SCRIPT_NEW_TAI_LUE},
    {6624, 6655, HB_SCRIPT_KHMER},
    {6656, 6683, HB_SCRIPT_BUGINESE},
    {6686, 6687, HB_SCRIPT_BUGINESE},
    {6688, 6750, HB_SCRIPT_TAI_THAM},
    {6752, 6780, HB_SCRIPT_TAI_THAM},
    {6783, 6793, HB_SCRIPT_TAI_THAM},
    {6800, 6809, HB_SCRIPT_TAI_THAM},
    {6816, 6829, HB_SCRIPT_TAI_THAM},
    {6912, 6987, HB_SCRIPT_BALINESE},
    {6992, 7036, HB_SCRIPT_BALINESE},
    {7040, 7103, HB_SCRIPT_SUNDANESE},
    {7104, 7155, HB_SCRIPT_BATAK},
    {7164, 7167, HB_SCRIPT_BATAK},
    {7168, 7223, HB_SCRIPT_LEPCHA},
    {7227, 7241, HB_SCRIPT_LEPCHA},
    {7245, 7247, HB_SCRIPT_LEPCHA},
    {7248, 7295, HB_SCRIPT_OL_CHIKI},
    {7360, 7367, HB_SCRIPT_SUNDANESE},
    {7376, 7378, HB_SCRIPT_INHERITED},
    {7379, 7379, HB_SCRIPT_COMMON},
    {7380, 7392, HB_SCRIPT_INHERITED},
    {7393, 7393, HB_SCRIPT_COMMON},
    {7394, 7400, HB_SCRIPT_INHERITED},
    {7401, 7404, HB_SCRIPT_COMMON},
    {7405, 7405, HB_SCRIPT_INHERITED},
    {7406, 7411, HB_SCRIPT_COMMON},
    {7412, 7412, HB_SCRIPT_INHERITED},
    {7413, 7414, HB_SCRIPT_COMMON},
    {7424, 7461, HB_SCRIPT_LATIN},
    {7462, 7466, HB_SCRIPT_GREEK},
    {7467, 7467, HB_SCRIPT_CYRILLIC},
    {7468, 7516, HB_SCRIPT_LATIN},
    {7517, 7521, HB_SCRIPT_GREEK},
    {7522, 7525, HB_SCRIPT_LATIN},
    {7526, 7530, HB_SCRIPT_GREEK},
    {7531, 7543, HB_SCRIPT_LATIN},
    {7544, 7544, HB_SCRIPT_CYRILLIC},
    {7545, 7614, HB_SCRIPT_LATIN},
    {7615, 7615, HB_SCRIPT_GREEK},
    {7616, 7654, HB_SCRIPT_INHERITED},
    {7676, 7679, HB_SCRIPT_INHERITED},
    {7680, 7935, HB_SCRIPT_LATIN},
    {7936, 7957, HB_SCRIPT_GREEK},
    {7960, 7965, HB_SCRIPT_GREEK},
    {7968, 8005, HB_SCRIPT_GREEK},
    {8008, 8013, HB_SCRIPT_GREEK},
    {8016, 8023, HB_SCRIPT_GREEK},
    {8025, 8025, HB_SCRIPT_GREEK},
    {8027, 8027, HB_SCRIPT_GREEK},
    {8029, 8029, HB_SCRIPT_GREEK},
    {8031, 8061, HB_SCRIPT_GREEK},
    {8064, 8116, HB_SCRIPT_GREEK},
    {8118, 8132, HB_SCRIPT_GREEK},
    {8134, 8147, HB_SCRIPT_GREEK},
    {8150, 8155, HB_SCRIPT_GREEK},
    {8157, 8175, HB_SCRIPT_GREEK},
    {8178, 8180, HB_SCRIPT_GREEK},
    {8182, 8190, HB_SCRIPT_GREEK},
    {8192, 8203, HB_SCRIPT_COMMON},
    {8204, 8205, HB_SCRIPT_INHERITED},
    {8206, 8292, HB_SCRIPT_COMMON},
    {8298, 8304, HB_SCRIPT_COMMON},
    {8305, 8305, HB_SCRIPT_LATIN},
    {8308, 8318, HB_SCRIPT_COMMON},
    {8319, 8319, HB_SCRIPT_LATIN},
    {8320, 8334, HB_SCRIPT_COMMON},
    {8336, 8348, HB_SCRIPT_LATIN},
    {8352, 8378, HB_SCRIPT_COMMON},
    {8400, 8432, HB_SCRIPT_INHERITED},
    {8448, 8485, HB_SCRIPT_COMMON},
    {8486, 8486, HB_SCRIPT_GREEK},
    {8487, 8489, HB_SCRIPT_COMMON},
    {8490, 8491, HB_SCRIPT_LATIN},
    {8492, 8497, HB_SCRIPT_COMMON},
    {8498, 8498, HB_SCRIPT_LATIN},
    {8499, 8525, HB_SCRIPT_COMMON},
    {8526, 8526, HB_SCRIPT_LATIN},
    {8527, 8543, HB_SCRIPT_COMMON},
    {8544, 8584, HB_SCRIPT_LATIN},
    {8585, 8585, HB_SCRIPT_COMMON},
    {8592, 9203, HB_SCRIPT_COMMON},
    {9216, 9254, HB_SCRIPT_COMMON},
    {9280, 9290, HB_SCRIPT_COMMON},
    {9312, 9983, HB_SCRIPT_COMMON},
    {9985, 10239, HB_SCRIPT_COMMON},
    {10240, 10495, HB_SCRIPT_BRAILLE},
    {10496, 11084, HB_SCRIPT_COMMON},
    {11088, 11097, HB_SCRIPT_COMMON},
    {11264, 11310, HB_SCRIPT_GLAGOLITIC},
    {11312, 11358, HB_SCRIPT_GLAGOLITIC},
    {11360, 11391, HB_SCRIPT_LATIN},
    {11392, 11507, HB_SCRIPT_COPTIC},
    {11513, 11519, HB_SCRIPT_COPTIC},
    {11520, 11557, HB_SCRIPT_GEORGIAN},
    {11559, 11559, HB_SCRIPT_GEORGIAN},
    {11565, 11565, HB_SCRIPT_GEORGIAN},
    {11568, 11623, HB_SCRIPT_TIFINAGH},
    {11631, 11632, HB_SCRIPT_TIFINAGH},
    {11647, 11647, HB_SCRIPT_TIFINAGH},
    {11648, 11670, HB_SCRIPT_ETHIOPIC},
    {11680, 11686, HB_SCRIPT_ETHIOPIC},
    {11688, 11694, HB_SCRIPT_ETHIOPIC},
    {11696, 11702, HB_SCRIPT_ETHIOPIC},
    {11704, 11710, HB_SCRIPT_ETHIOPIC},
    {11712, 11718, HB_SCRIPT_ETHIOPIC},
    {11720, 11726, HB_SCRIPT_ETHIOPIC},
    {11728, 11734, HB_SCRIPT_ETHIOPIC},
    {11736, 11742, HB_SCRIPT_ETHIOPIC},
    {11744, 11775, HB_SCRIPT_CYRILLIC},
    {11776, 11835, HB_SCRIPT_COMMON},
    {11904, 11929, HB_SCRIPT_HAN},
    {11931, 12019, HB_SCRIPT_HAN},
    {12032, 12245, HB_SCRIPT_HAN},
    {12272, 12283, HB_SCRIPT_COMMON},
    {12288, 12292, HB_SCRIPT_COMMON},
    {12293, 12293, HB_SCRIPT_HAN},
    {12294, 12294, HB_SCRIPT_COMMON},
    {12295, 12295, HB_SCRIPT_HAN},
    {12296, 12320, HB_SCRIPT_COMMON},
    {12321, 12329, HB_SCRIPT_HAN},
    {12330, 12333, HB_SCRIPT_INHERITED},
    {12334, 12335, HB_SCRIPT_HANGUL},
    {12336, 12343, HB_SCRIPT_COMMON},
    {12344, 12347, HB_SCRIPT_HAN},
    {12348, 12351, HB_SCRIPT_COMMON},
    {12353, 12438, HB_SCRIPT_HIRAGANA},
    {12441, 12442, HB_SCRIPT_INHERITED},
    {12443, 12444, HB_SCRIPT_COMMON},
    {12445, 12447, HB_SCRIPT_HIRAGANA},
    {12448, 12448, HB_SCRIPT_COMMON},
    {12449, 12538, HB_SCRIPT_KATAKANA},
    {12539, 12540, HB_SCRIPT_COMMON},
    {12541, 12543, HB_SCRIPT_KATAKANA},
    {12549, 12589, HB_SCRIPT_BOPOMOFO},
    {12593, 12686, HB_SCRIPT_HANGUL},
    {12688, 12703, HB_SCRIPT_COMMON},
    {12704, 12730, HB_SCRIPT_BOPOMOFO},
    {12736, 12771, HB_SCRIPT_COMMON},
    {12784, 12799, HB_SCRIPT_KATAKANA},
    {12800, 12830, HB_SCRIPT_HANGUL},
    {12832, 12895, HB_SCRIPT_COMMON},
    {12896, 12926, HB_SCRIPT_HANGUL},
    {12927, 13007, HB_SCRIPT_COMMON},
    {13008, 13054, HB_SCRIPT_KATAKANA},
    {13056, 13143, HB_SCRIPT_KATAKANA},
    {13144, 13311, HB_SCRIPT_COMMON},
    {13312, 19893, HB_SCRIPT_HAN},
    {19904, 19967, HB_SCRIPT_COMMON},
    {19968, 40908, HB_SCRIPT_HAN},
    {40960, 42124, HB_SCRIPT_YI},
    {42128, 42182, HB_SCRIPT_YI},
    {42192, 42239, HB_SCRIPT_LISU},
    {42240, 42539, HB_SCRIPT_VAI},
    {42560, 42647, HB_SCRIPT_CYRILLIC},
    {42655, 42655, HB_SCRIPT_CYRILLIC},
    {42656, 42743, HB_SCRIPT_BAMUM},
    {42752, 42785, HB_SCRIPT_COMMON},
    {42786, 42887, HB_SCRIPT_LATIN},
    {42888, 42890, HB_SCRIPT_COMMON},
    {42891, 42894, HB_SCRIPT_LATIN},
    {42896, 42899, HB_SCRIPT_LATIN},
    {42912, 42922, HB_SCRIPT_LATIN},
    {43000, 43007, HB_SCRIPT_LATIN},
    {43008, 43051, HB_SCRIPT_SYLOTI_NAGRI},
    {43056, 43065, HB_SCRIPT_COMMON},
    {43072, 43127, HB_SCRIPT_PHAGS_PA},
    {43136, 43204, HB_SCRIPT_SAURASHTRA},
    {43214, 43225, HB_SCRIPT_SAURASHTRA},
    {43232, 43259, HB_SCRIPT_DEVANAGARI},
    {43264, 43311, HB_SCRIPT_KAYAH_LI},
    {43312, 43347, HB_SCRIPT_REJANG},
    {43359, 43359, HB_SCRIPT_REJANG},
    {43360, 43388, HB_SCRIPT_HANGUL},
    {43392, 43469, HB_SCRIPT_JAVANESE},
    {43471, 43481, HB_SCRIPT_JAVANESE},
    {43486, 43487, HB_SCRIPT_JAVANESE},
    {43520, 43574, HB_SCRIPT_CHAM},
    {43584, 43597, HB_SCRIPT_CHAM},
    {43600, 43609, HB_SCRIPT_CHAM},
    {43612, 43615, HB_SCRIPT_CHAM},
    {43616, 43643, HB_SCRIPT_MYANMAR},
    {43648, 43714, HB_SCRIPT_TAI_VIET},
    {43739, 43743, HB_SCRIPT_TAI_VIET},
    {43744, 43766, HB_SCRIPT_MEETEI_MAYEK},
    {43777, 43782, HB_SCRIPT_ETHIOPIC},
    {43785, 43790, HB_SCRIPT_ETHIOPIC},
    {43793, 43798, HB_SCRIPT_ETHIOPIC},
    {43808, 43814, HB_SCRIPT_ETHIOPIC},
    {43816, 43822, HB_SCRIPT_ETHIOPIC},
    {43968, 44013, HB_SCRIPT_MEETEI_MAYEK},
    {44016, 44025, HB_SCRIPT_MEETEI_MAYEK},
    {44032, 55203, HB_SCRIPT_HANGUL},
    {55216, 55238, HB_SCRIPT_HANGUL},
    {55243, 55291, HB_SCRIPT_HANGUL},
    {63744, 64109, HB_SCRIPT_HAN},
    {64112, 64217, HB_SCRIPT_HAN},
    {64256, 64262, HB_SCRIPT_LATIN},
    {64275, 64279, HB_SCRIPT_ARMENIAN},
    {64285, 64310, HB_SCRIPT_HEBREW},
    {64312, 64316, HB_SCRIPT_HEBREW},
    {64318, 64318, HB_SCRIPT_HEBREW},
    {64320, 64321, HB_SCRIPT_HEBREW},
    {64323, 64324, HB_SCRIPT_HEBREW},
    {64326, 64335, HB_SCRIPT_HEBREW},
    {64336, 64449, HB_SCRIPT_ARABIC},
    {64467, 64829, HB_SCRIPT_ARABIC},
    {64830, 64831, HB_SCRIPT_COMMON},
    {64848, 64911, HB_SCRIPT_ARABIC},
    {64914, 64967, HB_SCRIPT_ARABIC},
    {65008, 65020, HB_SCRIPT_ARABIC},
    {65021, 65021, HB_SCRIPT_COMMON},
    {65024, 65039, HB_SCRIPT_INHERITED},
    {65040, 65049, HB_SCRIPT_COMMON},
    {65056, 65062, HB_SCRIPT_INHERITED},
    {65072, 65106, HB_SCRIPT_COMMON},
    {65108, 65126, HB_SCRIPT_COMMON},
    {65128, 65131, HB_SCRIPT_COMMON},
    {65136, 65140, HB_SCRIPT_ARABIC},
    {65142, 65276, HB_SCRIPT_ARABIC},
    {65279, 65279, HB_SCRIPT_COMMON},
    {65281, 65312, HB_SCRIPT_COMMON},
    {65313, 65338, HB_SCRIPT_LATIN},
    {65339, 65344, HB_SCRIPT_COMMON},
    {65345, 65370, HB_SCRIPT_LATIN},
    {65371, 65381, HB_SCRIPT_COMMON},
    {65382, 65391, HB_SCRIPT_KATAKANA},
    {65392, 65392, HB_SCRIPT_COMMON},
    {65393, 65437, HB_SCRIPT_KATAKANA},
    {65438, 65439, HB_SCRIPT_COMMON},
    {65440, 65470, HB_SCRIPT_HANGUL},
    {65474, 65479, HB_SCRIPT_HANGUL},
    {65482, 65487, HB_SCRIPT_HANGUL},
    {65490, 65495, HB_SCRIPT_HANGUL},
    {65498, 65500, HB_SCRIPT_HANGUL},
    {65504, 65510, HB_SCRIPT_COMMON},
    {65512, 65518, HB_SCRIPT_COMMON},
    {65529, 65533, HB_SCRIPT_COMMON},
    {65536, 65547, HB_SCRIPT_LINEAR_B},
    {65549, 65574, HB_SCRIPT_LINEAR_B},
    {65576, 65594, HB_SCRIPT_LINEAR_B},
    {65596, 65597, HB_SCRIPT_LINEAR_B},
    {65599, 65613, HB_SCRIPT_LINEAR_B},
    {65616, 65629, HB_SCRIPT_LINEAR_B},
    {65664, 65786, HB_SCRIPT_LINEAR_B},
    {65792, 65794, HB_SCRIPT_COMMON},
    {65799, 65843, HB_SCRIPT_COMMON},
    {65847, 65855, HB_SCRIPT_COMMON},
    {65856, 65930, HB_SCRIPT_GREEK},
    {65936, 65947, HB_SCRIPT_COMMON},
    {66000, 66044, HB_SCRIPT_COMMON},
    {66045, 66045, HB_SCRIPT_INHERITED},
    {66176, 66204, HB_SCRIPT_LYCIAN},
    {66208, 66256, HB_SCRIPT_CARIAN},
    {66304, 66334, HB_SCRIPT_OLD_ITALIC},
    {66336, 66339, HB_SCRIPT_OLD_ITALIC},
    {66352, 66378, HB_SCRIPT_GOTHIC},
    {66432, 66461, HB_SCRIPT_UGARITIC},
    {66463, 66463, HB_SCRIPT_UGARITIC},
    {66464, 66499, HB_SCRIPT_OLD_PERSIAN},
    {66504, 66517, HB_SCRIPT_OLD_PERSIAN},
    {66560, 66639, HB_SCRIPT_DESERET},
    {66640, 66687, HB_SCRIPT_SHAVIAN},
    {66688, 66717, HB_SCRIPT_OSMANYA},
    {66720, 66729, HB_SCRIPT_OSMANYA},
    {67584, 67589, HB_SCRIPT_CYPRIOT},
    {67592, 67592, HB_SCRIPT_CYPRIOT},
    {67594, 67637, HB_SCRIPT_CYPRIOT},
    {67639, 67640, HB_SCRIPT_CYPRIOT},
    {67644, 67644, HB_SCRIPT_CYPRIOT},
    {67647, 67647, HB_SCRIPT_CYPRIOT},
    {67648, 67669, HB_SCRIPT_IMPERIAL_ARAMAIC},
    {67671, 67679, HB_SCRIPT_IMPERIAL_ARAMAIC},
    {67840, 67867, HB_SCRIPT_PHOENICIAN},
    {67871, 67871, HB_SCRIPT_PHOENICIAN},
    {67872, 67897, HB_SCRIPT_LYDIAN},
    {67903, 67903, HB_SCRIPT_LYDIAN},
    {67968, 67999, HB_SCRIPT_MEROITIC_HIEROGLYPHS},
    {68000, 68023, HB_SCRIPT_MEROITIC_CURSIVE},
    {68030, 68031, HB_SCRIPT_MEROITIC_CURSIVE},
    {68096, 68099, HB_SCRIPT_KHAROSHTHI},
    {68101, 68102, HB_SCRIPT_KHAROSHTHI},
    {68108, 68115, HB_SCRIPT_KHAROSHTHI},
    {68117, 68119, HB_SCRIPT_KHAROSHTHI},
    {68121, 68147, HB_SCRIPT_KHAROSHTHI},
    {68152, 68154, HB_SCRIPT_KHAROSHTHI},
    {68159, 68167, HB_SCRIPT_KHAROSHTHI},
    {68176, 68184, HB_SCRIPT_KHAROSHTHI},
    {68192, 68223, HB_SCRIPT_OLD_SOUTH_ARABIAN},
    {68352, 68405, HB_SCRIPT_AVESTAN},
    {68409, 68415, HB_SCRIPT_AVESTAN},
    {68416, 68437, HB_SCRIPT_INSCRIPTIONAL_PARTHIAN},
    {68440, 68447, HB_SCRIPT_INSCRIPTIONAL_PARTHIAN},
    {68448, 68466, HB_SCRIPT_INSCRIPTIONAL_PAHLAVI},
    {68472, 68479, HB_SCRIPT_INSCRIPTIONAL_PAHLAVI},
    {68608, 68680, HB_SCRIPT_OLD_TURKIC},
    {69216, 69246, HB_SCRIPT_ARABIC},
    {69632, 69709, HB_SCRIPT_BRAHMI},
    {69714, 69743, HB_SCRIPT_BRAHMI},
    {69760, 69825, HB_SCRIPT_KAITHI},
    {69840, 69864, HB_SCRIPT_SORA_SOMPENG},
    {69872, 69881, HB_SCRIPT_SORA_SOMPENG},
    {69888, 69940, HB_SCRIPT_CHAKMA},
    {69942, 69955, HB_SCRIPT_CHAKMA},
    {70016, 70088, HB_SCRIPT_SHARADA},
    {70096, 70105, HB_SCRIPT_SHARADA},
    {71296, 71351, HB_SCRIPT_TAKRI},
    {71360, 71369, HB_SCRIPT_TAKRI},
    {73728, 74606, HB_SCRIPT_CUNEIFORM},
    {74752, 74850, HB_SCRIPT_CUNEIFORM},
    {74864, 74867, HB_SCRIPT_CUNEIFORM},
    {77824, 78894, HB_SCRIPT_EGYPTIAN_HIEROGLYPHS},
    {92160, 92728, HB_SCRIPT_BAMUM},
    {93952, 94020, HB_SCRIPT_MIAO},
    {94032, 94078, HB_SCRIPT_MIAO},
    {94095, 94111, HB_SCRIPT_MIAO},
    {110592, 110592, HB_SCRIPT_KATAKANA},
    {110593, 110593, HB_SCRIPT_HIRAGANA},
    {118784, 119029, HB_SCRIPT_COMMON},
    {119040, 119078, HB_SCRIPT_COMMON},
    {119081, 119142, HB_SCRIPT_COMMON},
    {119143, 119145, HB_SCRIPT_INHERITED},
    {119146, 119162, HB_SCRIPT_COMMON},
    {119163, 119170, HB_SCRIPT_INHERITED},
    {119171, 119172, HB_SCRIPT_COMMON},
    {119173, 119179, HB_SCRIPT_INHERITED},
    {119180, 119209, HB_SCRIPT_COMMON},
    {119210, 119213, HB_SCRIPT_INHERITED},
    {119214, 119261, HB_SCRIPT_COMMON},
    {119296, 119365, HB_SCRIPT_GREEK},
    {119552, 119638, HB_SCRIPT_COMMON},
    {119648, 119665, HB_SCRIPT_COMMON},
    {119808, 119892, HB_SCRIPT_COMMON},
    {119894, 119964, HB_SCRIPT_COMMON},
    {119966, 119967, HB_SCRIPT_COMMON},
    {119970, 119970, HB_SCRIPT_COMMON},
    {119973, 119974, HB_SCRIPT_COMMON},
    {119977, 119980, HB_SCRIPT_COMMON},
    {119982, 119993, HB_SCRIPT_COMMON},
    {119995, 119995, HB_SCRIPT_COMMON},
    {119997, 120003, HB_SCRIPT_COMMON},
    {120005, 120069, HB_SCRIPT_COMMON},
    {120071, 120074, HB_SCRIPT_COMMON},
    {120077, 120084, HB_SCRIPT_COMMON},
    {120086, 120092, HB_SCRIPT_COMMON},
    {120094, 120121, HB_SCRIPT_COMMON},
    {120123, 120126, HB_SCRIPT_COMMON},
    {120128, 120132, HB_SCRIPT_COMMON},
    {120134, 120134, HB_SCRIPT_COMMON},
    {120138, 120144, HB_SCRIPT_COMMON},
    {120146, 120485, HB_SCRIPT_COMMON},
    {120488, 120779, HB_SCRIPT_COMMON},
    {120782, 120831, HB_SCRIPT_COMMON},
    {126464, 126467, HB_SCRIPT_ARABIC},
    {126469, 126495, HB_SCRIPT_ARABIC},
    {126497, 126498, HB_SCRIPT_ARABIC},
    {126500, 126500, HB_SCRIPT_ARABIC},
    {126503, 126503, HB_SCRIPT_ARABIC},
    {126505, 126514, HB_SCRIPT_ARABIC},
    {126516, 126519, HB_SCRIPT_ARABIC},
    {126521, 126521, HB_SCRIPT_ARABIC},
    {126523, 126523, HB_SCRIPT_ARABIC},
    {126530, 126530, HB_SCRIPT_ARABIC},
    {126535, 126535, HB_SCRIPT_ARABIC},
    {126537, 126537, HB_SCRIPT_ARABIC},
    {126539, 126539, HB_SCRIPT_ARABIC},
    {126541, 126543, HB_SCRIPT_ARABIC},
    {126545, 126546, HB_SCRIPT_ARABIC},
    {126548, 126548, HB_SCRIPT_ARABIC},
    {126551, 126551, HB_SCRIPT_ARABIC},
    {126553, 126553, HB_SCRIPT_ARABIC},
    {126555, 126555, HB_SCRIPT_ARABIC},
    {126557, 126557, HB_SCRIPT_ARABIC},
    {126559, 126559, HB_SCRIPT_ARABIC},
    {126561, 126562, HB_SCRIPT_ARABIC},
    {126564, 126564, HB_SCRIPT_ARABIC},
    {126567, 126570, HB_SCRIPT_ARABIC},
    {126572, 126578, HB_SCRIPT_ARABIC},
    {126580, 126583, HB_SCRIPT_ARABIC},
    {126585, 126588, HB_SCRIPT_ARABIC},
    {126590, 126590, HB_SCRIPT_ARABIC},
    {126592, 126601, HB_SCRIPT_ARABIC},
    {126603, 126619, HB_SCRIPT_ARABIC},
    {126625, 126627, HB_SCRIPT_ARABIC},
    {126629, 126633, HB_SCRIPT_ARABIC},
    {126635, 126651, HB_SCRIPT_ARABIC},
    {126704, 126705, HB_SCRIPT_ARABIC},
    {126976, 127019, HB_SCRIPT_COMMON},
    {127024, 127123, HB_SCRIPT_COMMON},
    {127136, 127150, HB_SCRIPT_COMMON},
    {127153, 127166, HB_SCRIPT_COMMON},
    {127169, 127183, HB_SCRIPT_COMMON},
    {127185, 127199, HB_SCRIPT_COMMON},
    {127232, 127242, HB_SCRIPT_COMMON},
    {127248, 127278, HB_SCRIPT_COMMON},
    {127280, 127339, HB_SCRIPT_COMMON},
    {127344, 127386, HB_SCRIPT_COMMON},
    {127462, 127487, HB_SCRIPT_COMMON},
    {127488, 127488, HB_SCRIPT_HIRAGANA},
    {127489, 127490, HB_SCRIPT_COMMON},
    {127504, 127546, HB_SCRIPT_COMMON},
    {127552, 127560, HB_SCRIPT_COMMON},
    {127568, 127569, HB_SCRIPT_COMMON},
    {127744, 127776, HB_SCRIPT_COMMON},
    {127792, 127797, HB_SCRIPT_COMMON},
    {127799, 127868, HB_SCRIPT_COMMON},
    {127872, 127891, HB_SCRIPT_COMMON},
    {127904, 127940, HB_SCRIPT_COMMON},
    {127942, 127946, HB_SCRIPT_COMMON},
    {127968, 127984, HB_SCRIPT_COMMON},
    {128000, 128062, HB_SCRIPT_COMMON},
    {128064, 128064, HB_SCRIPT_COMMON},
    {128066, 128247, HB_SCRIPT_COMMON},
    {128249, 128252, HB_SCRIPT_COMMON},
    {128256, 128317, HB_SCRIPT_COMMON},
    {128320, 128323, HB_SCRIPT_COMMON},
    {128336, 128359, HB_SCRIPT_COMMON},
    {128507, 128576, HB_SCRIPT_COMMON},
    {128581, 128591, HB_SCRIPT_COMMON},
    {128640, 128709, HB_SCRIPT_COMMON},
    {128768, 128883, HB_SCRIPT_COMMON},
    {131072, 173782, HB_SCRIPT_HAN},
    {173824, 177972, HB_SCRIPT_HAN},
    {177984, 178205, HB_SCRIPT_HAN},
    {194560, 195101, HB_SCRIPT_HAN},
    {917505, 917505, HB_SCRIPT_COMMON},
    {917536, 917631, HB_SCRIPT_COMMON}
};

const UInt32 HbUnicode::g_scriptTableSize = sizeof(HbUnicode::g_scriptTable) / sizeof(HbUnicode::g_scriptTable[0]);

}}}}
