//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_HbUnicode_h)
#define Candera_HbUnicode_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbInclude.h>

namespace Candera { namespace TextRendering { 
namespace Internal { namespace HarfBuzzShaper {

    class HbUnicode {
    public:
        static void SetFuncs(hb_buffer_t* buffer);

        static hb_unicode_combining_class_t FindCombiningClass(hb_codepoint_t codepoint);
        static hb_bool_t IsEastAsianWidthWide(hb_codepoint_t codepoint);
        static hb_unicode_general_category_t FindGeneralCategory(hb_codepoint_t codepoint);
        static hb_codepoint_t FindBidiMirror(hb_codepoint_t codepoint);
        static hb_script_t FindScript(hb_codepoint_t codepoint);
        static hb_bool_t Compose(hb_codepoint_t *ab, hb_codepoint_t a, hb_codepoint_t b);
        static hb_bool_t Decompose(hb_codepoint_t ab, hb_codepoint_t *a, hb_codepoint_t *b);

    private:
        static hb_unicode_funcs_t* CreateFuncs();

        struct CombiningClassData {
            hb_codepoint_t start;
            hb_codepoint_t end;
            UInt8 combiningClass;
        };
        static const CombiningClassData g_combiningClassTable[];
        static const UInt32 g_combiningClassTableSize;

        struct EastAsianWidthData {
            hb_codepoint_t start;
            hb_codepoint_t end;
        };
        static const EastAsianWidthData g_eastAsianWidthTable[];
        static const UInt32 g_eastAsianWidthTableSize;

        struct GeneralCategoryData {
            hb_codepoint_t start;
            hb_codepoint_t end;
            hb_unicode_general_category_t generalCategory;
        };
        static const GeneralCategoryData g_generalCategoryTable[];
        static const UInt32 g_generalCategoryTableSize;

        struct BidiMirroringData {
            hb_codepoint_t value;
            hb_codepoint_t mirror;
        };
        static const BidiMirroringData g_bidiMirroringTable[];
        static const UInt32 g_bidiMirroringTableSize;

        struct ScriptData {
            hb_codepoint_t start;
            hb_codepoint_t end;
            hb_script_t script;
        };
        static const ScriptData g_scriptTable[];
        static const UInt32 g_scriptTableSize;

        struct CanonicalCompositionData {
            hb_codepoint_t first;
            hb_codepoint_t second;
            hb_codepoint_t value;
        };
        static const CanonicalCompositionData g_canonicalCompositionTable[];
        static const UInt32 g_canonicalCompositionTableSize;

        struct CanonicalDecompositionData {
            hb_codepoint_t value;
            hb_codepoint_t first;
            hb_codepoint_t second;
        };
        static const CanonicalDecompositionData g_canonicalDecompositionTable[];
        static const UInt32 g_canonicalDecompositionTableSize;
    }; // class HbUnicode

}}}} // namespace

#endif    // Candera_HbUnicode_h

