//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(Candera_HbFreetype_h)
#define Candera_HbFreetype_h

#include <Candera/TextEngine/Internal/HarfBuzzShaper/HbInclude.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <Candera/TextEngine/Freetype/FtInclude.h>

namespace Candera { namespace TextRendering { 

    namespace Internal {
        class FtFont;
        class FtGlyphRenderer;
    }

namespace Internal { namespace HarfBuzzShaper {

    class HbFreetypeFont {
    public:
        HbFreetypeFont();
        ~HbFreetypeFont();

        void Initialize(const Internal::FtGlyphRenderer& glyphRenderer, const Internal::FtFont& font);
        void Finalize();

        hb_font_t* GetHbFont() const { return m_hbFont; }

        inline hb_codepoint_t GetGlyph(hb_codepoint_t unicode) const;
        inline hb_position_t GetGlyphHAdvance(hb_codepoint_t glyph);
        inline hb_bool_t GetGlyphHOrigin(hb_codepoint_t glyph, hb_position_t &x, hb_position_t &y);
        inline hb_position_t GetGlyphHKerning(hb_codepoint_t glyphA, hb_codepoint_t glyphB) const;
        inline hb_bool_t GetGlyphContourPoint(hb_codepoint_t glyph, HbInterfaceUnsignedInt pointIndex, hb_position_t &x, hb_position_t &y) const;

    private:
        static hb_font_funcs_t* CreateFuncs();
        void UpdateLastGlyphInfo(hb_codepoint_t glyph);
        
        // Permanent data.
        hb_font_t* m_hbFont;

        // Temporary data.
        const Internal::FtFont* m_font;
        const Internal::FtGlyphRenderer* m_glyphRenderer;

        // Cache for glyph measurements reuse.
        GlyphIndex m_lastGlyphIndex;
        GlyphBitmap m_lastGlyphInfo;
    }; // class HbFreetypeFont

}}}} // namespace

#endif    // Candera_HbFreetype_h

