//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################



#if !defined(Candera_GlyphRenderer_h)
#define Candera_GlyphRenderer_h

#include <Candera/TextEngine/FontEngineDefinition.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/Font.h>

namespace Candera {
    namespace TextRendering {

        class TextRenderer;
        namespace Internal {

        /** @addtogroup CanderaTextEngine
         *  @{
         */

        /**
         *  @brief GlyphRenderer is responsible to supply glyph bitmaps to Candera text rendering function
         *  This is a Candera private class and must not be used by other components
         */
        class GlyphRenderer : public FontEngineDefinition::GlyphRenderer {
            FEATSTD_TYPEDEF_BASE(FontEngineDefinition::GlyphRenderer);

        public:
        
            GlyphRenderer(const GlyphRenderInfo& renderInfo) :
                Base(renderInfo)
            {
            }

            FEATSTD_LINT_NEXT_EXPRESSION(1511, "symbol hidden from public API with using, hiding is accepted")
            GlyphIndex GetGlyphIndex(const Font &font, Utf32 unicode, bool ignoreDefault = false) const
            {
                return Base::GetGlyphIndex(font, unicode, ignoreDefault);
            }

            FEATSTD_LINT_NEXT_EXPRESSION(1511, "symbol hidden from public API with using, hiding is accepted")
            GlyphIndex GetGlyphIndexVariant(const Font &font, Utf32 unicode, UInt32 variantSelector) const
            {
                return Base::GetGlyphIndexVariant(font, unicode, variantSelector);
            }

            /**
             *  Retrieve the glyph bitmap for the given character code and font.
             *  The life time of the glyph data terminates with the next call to GetGlyphBitmap.
             *  @param bmp Receives glyph bitmap data.
             *  @param font Font from which the glyph should be generated.
             *  @param glyph Retrieve glyph bitmap for this index.
             *  @param useCache True for using cache to avoid some recomputation.
             *  @param access Pointer to an object used at allocating cache items; 0 for default.
             *  @return True if the glyph could be retrieved, false otherwise.
             */
            FEATSTD_LINT_NEXT_EXPRESSION(1511, "symbol hidden from public API with using, hiding is accepted")
            bool GetGlyphBitmap(GlyphBitmap &bmp, const Font &font, GlyphIndex glyph) const
            {
                return Base::GetGlyphBitmap(bmp, font, glyph);
            }

            FEATSTD_LINT_NEXT_EXPRESSION(1511, "symbol hidden from public API with using, hiding is accepted")
            PixelPosition2D GetGlyphKerning(GlyphIndex currentGlyph, GlyphIndex nextGlyph, const Font& font) const
            {
                return Base::GetGlyphKerning(currentGlyph, nextGlyph, font);
            }

            /**
             * Update the default codepoint from the render info used by the renderer
             * @param defaultGlyph Codepoint to be used as default
             */
            FEATSTD_LINT_NEXT_EXPRESSION(1511, "symbol hidden from public API with using, hiding is accepted")
            void SetDefaultCodepoint(CodePoint defaultGlyph)
            {
                Base::SetDefaultCodepoint(defaultGlyph);
            }

        private:
            using Base::GetGlyphIndex;
            using Base::GetGlyphKerning;
            using Base::GetGlyphBitmap;
            using Base::SetDefaultCodepoint;

            FEATSTD_LINT_CURRENT_SCOPE(1509, "base class has intentionally no virtual dtor")
        };

        /** @} */ // end of CanderaTextEngine
        
        }// namespace Internal
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_GlyphRenderer_h
