//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "GlyphCacheMap.h"

namespace Candera {
    namespace TextRendering {
        namespace Internal {


            GlyphCacheMap::GlyphCacheMap() :m_entryCount(0)
            {

            }

            bool GlyphCacheMap::AddEntry(GlyphIndex const& key, UInt8* value)
            {
                bool result = m_glyphCacheMap.Insert(key, value);
                if (result) { m_entryCount++; }
                return result;
            }

            Candera::UInt8* GlyphCacheMap::GetEntry(GlyphIndex const& key) const
            {
                UInt8** result = m_glyphCacheMap.Find(key);
                if (result == 0) {
                    return 0;
                }
                else {
                    return *result;
                }
            }

            bool GlyphCacheMap::RemoveEntry(GlyphIndex const& key)
            {
                bool result = m_glyphCacheMap.Remove(key);
                if (result) { m_entryCount--; }
                return result;
            }

            void GlyphCacheMap::Flush()
            {
                m_glyphCacheMap.Clear();
                m_entryCount = 0;
            }

            Candera::SizeType GlyphCacheMap::GetCount() const
            {
                return m_entryCount;
            }

        }
    }
}
