//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_GlyphTextMeasureContext_h)
#define Candera_GlyphTextMeasureContext_h

#include <Candera/TextEngine/TextMeasureContext.h>
#include <Candera/TextEngine/TextRect.h>

namespace Candera { namespace TextRendering { 

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief GlyphTextMeasureContext is used to measure the glyph bitmaps extents.
 *  
 *  This class builds the smallest axis aligned rectangle that contains the
 *  surfaces of all the glyph bitmaps that are measured by it.
 *
 *  This class is best used when needing to determine the visible area of the
 *  text, for instance when picking.
 */
class GlyphTextMeasureContext : public TextMeasureContext{
public:
    GlyphTextMeasureContext(const TextRenderContext* referenceContext = 0);

    /**
     * Retrieve the rectangle computed by the context.
     * The rectangle is equal to TextRect() if nothing was measured.
     * @return The computed rectangle.
     */
    const TextRect& GetTextRectangle() const;

private:
    // Overrides function from TextMeasureContext.
    virtual void Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph) ;

    TextRect m_textRectangle;
};

 /** @} */ // end of CanderaTextEngine

}// namespace TextRendering
}// namespace Candera

#endif// Candera_GlyphTextMeasureContext_h
