//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/GlyphCacheAccess.h>
#include <Candera/TextEngine/Internal/CacheAccessType.h>

namespace Candera {
    namespace TextRendering {
#ifndef CANDERA_DEPRECATED_3_2_1
#error Create with 2 parameters shall become abstract.
#else

        UInt8* GlyphCacheAccess::Create(const GlyphBitmap& bitmap, UInt8* cacheItem)
        {
            FEATSTD_UNUSED(cacheItem);
            static bool isRecursive = false;
            FEATSTD_DEBUG_ASSERT(!isRecursive);
            if (isRecursive) {
                return 0; //The derived class should implement at least one virtual Create overload.
            }
            isRecursive = true;
            UInt8* result = Create(bitmap, 0);
            isRecursive = false;
            return result;
        }

#endif

        Candera::TextRendering::Internal::CacheAccessType::Enum GlyphCacheAccess::GetCacheAccessType() const
        {
            return TextRendering::Internal::CacheAccessType::Other;
        }
    }
}
