//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_FtInclude_h)
#define Candera_FtInclude_h

/* FT2 include files must be included within this file only. No other
   Candera FT specific files must include FT2 headers. */

// enforce Candera options file
//#define FT_CONFIG_OPTIONS_H <Candera/TextEngine/Freetype/FtCdaOptions.h>
//#define FT_CONFIG_MODULES_H <Candera/TextEngine/Freetype/FtCdaModules.h>

// needed for trace enumeration in ftdebug.h
#if !defined(FT2_BUILD_LIBRARY)
    #define FT2_BUILD_LIBRARY
#endif
#if defined(FEATSTD_DEBUG)
    #ifndef FT_DEBUG_LEVEL_ERROR
        #define FT_DEBUG_LEVEL_ERROR
        #define FT_UNDEFINE_DEBUG_LEVEL_ERROR
    #endif
    #ifndef FT_DEBUG_LEVEL_TRACE
        #define FT_DEBUG_LEVEL_TRACE
        #define FT_UNDEFINE_DEBUG_LEVEL_TRACE
    #endif
#endif

// include statements with macro replacement sometimes not resolved correctly by lint
/*lint --e{12}*/

#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_OUTLINE_H
#include FT_CACHE_H
#include FT_TRUETYPE_IDS_H
#include FT_ADVANCES_H
#include FT_BITMAP_H

#include FT_INTERNAL_DEBUG_H
#include FT_INTERNAL_OBJECTS_H
#include FT_INTERNAL_MEMORY_H

#undef FT2_BUILD_LIBRARY

// Define types to use with FreeType interface:

#ifdef __cplusplus
namespace Candera {
    namespace TextRendering {
        namespace Internal {
#endif

typedef int FtInterfaceInt;
typedef long FtInterfaceLong;
typedef unsigned long FtInterfaceUnsignedLong;
typedef char FtInterfaceChar;
typedef unsigned char FtInterfaceUnsignedChar;

// FT_UInt32 is not redefined here!
/*lint --e{31}*/
static const FT_UInt32 c_ftLoadDefault = FT_LOAD_DEFAULT;
static const FT_UInt32 c_ftLoadRender = FT_LOAD_RENDER;

static const FT_UInt32 c_ftLoadNoHinting        = FT_LOAD_NO_HINTING;
static const FT_UInt32 c_ftLoadVerticalLayout   = FT_LOAD_VERTICAL_LAYOUT;
static const FT_UInt32 c_ftLoadNoAutohint       = FT_LOAD_NO_AUTOHINT;
static const FT_UInt32 c_ftLoadForceAutohint    = FT_LOAD_FORCE_AUTOHINT;
static const FT_UInt32 c_ftLoadCropBitmap       = FT_LOAD_CROP_BITMAP;
static const FT_UInt32 c_ftLoadPedantic         = FT_LOAD_PEDANTIC;
static const FT_UInt32 c_ftLoadMonochrome       = FT_LOAD_MONOCHROME;

static const FT_UInt32 c_ftLoadTargetNormal   = FT_LOAD_TARGET_NORMAL;
static const FT_UInt32 c_ftLoadTargetLight    = FT_LOAD_TARGET_LIGHT;
static const FT_UInt32 c_ftLoadTargetMono     = FT_LOAD_TARGET_MONO;
static const FT_UInt32 c_ftLoadTargetLcd      = FT_LOAD_TARGET_LCD;
static const FT_UInt32 c_ftLoadTargetLcdV     = FT_LOAD_TARGET_LCD_V;

static const FT_Render_Mode c_ftRenderModeNormal   = FT_RENDER_MODE_NORMAL;
static const FT_Render_Mode c_ftRenderModeLight    = FT_RENDER_MODE_LIGHT;
static const FT_Render_Mode c_ftRenderModeMono     = FT_RENDER_MODE_MONO;
static const FT_Render_Mode c_ftRenderModeLcd      = FT_RENDER_MODE_LCD;
static const FT_Render_Mode c_ftRenderModeLcdV     = FT_RENDER_MODE_LCD_V;

#ifdef __cplusplus
        }
    }
}
#endif

#endif //Candera_FtInclude_h)
