//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################



#if !defined(Candera_FtGlyphRenderer_h)
#define Candera_FtGlyphRenderer_h

#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/Internal/GlyphRenderInfo.h>

namespace Candera {

    namespace TextRendering {

        class TextCoordinate;
        class TextRect;
        class TextRenderer;
        class GlyphCacheAccess;

        struct GlyphBitmap;

        namespace Internal {
            class FtFont;

            /** @addtogroup FreetypeTextEngine
            *  @{
            */

            class FtCustomGlyphCacheAccess;

            /** @brief FT2 specific implementation of GylphRenderer */
            class FtGlyphRenderer {
            public:
                FtGlyphRenderer(const Internal::GlyphRenderInfo& renderInfo);
                virtual ~FtGlyphRenderer();

                GlyphIndex GetGlyphIndex(const FtFont &font, Utf32 unicode, bool ignoreDefault = false) const;
                // FreeType integration and caches do not support variant call by this function.
                // It will be redirected to GetGlyphIndex.
                GlyphIndex GetGlyphIndexVariant(const FtFont &font, Utf32 unicode, UInt32 variantSelector) const;
                bool GetGlyphBitmap(GlyphBitmap &bmp, const FtFont &font, GlyphIndex glyph) const;
                PixelPosition2D GetGlyphKerning(GlyphIndex currentGlyph, GlyphIndex nextGlyph, const FtFont& font) const;

                FT_Face GetFace(const FtFont &font) const;
                
                bool LoadContourPoint(TextCoordinate &contour, const FtFont& font, GlyphIndex glyph, UInt32 pointIndex) const;

                static bool ConvertMonochromToGray(FT_Bitmap *source);

                void SetDefaultCodepoint(CodePoint defaultGlyph) { m_renderInfo.defaultGlyph = defaultGlyph; }

            private:
                bool LookupCacheData(GlyphBitmap &bmp, const FtFont&font, GlyphIndex glyph) const;
                bool LoadImageData(GlyphBitmap &bmp, const FtFont& font, GlyphIndex glyph) const;

                Internal::GlyphRenderInfo m_renderInfo;
            };

            /** @} */ // end of FreetypeTextEngine

        }// namespace Internal
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_FtGlyphRenderer_h

