//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################



#if !defined(Candera_FtCustomGlyphCacheAccess_h)
#define Candera_FtCustomGlyphCacheAccess_h

#include <Candera/Environment.h>
#include <Candera/TextEngine/Freetype/FtCustomGlyphCache.h>
#include <Candera/TextEngine/GlyphBitmap.h>
#include <FeatStd/Util/PointerUtil.h>

CANDERA_UNIT_TEST_CLASS_DECLARATION(FtCustomGlyphCacheAccessTest)

namespace Candera {
    namespace TextRendering {

        namespace Internal {

            /** @addtogroup FreetypeTextEngine
            *  @{
            */

            extern "C" FT_Byte* FtCustomGlyphCacheAccessProcess( FtCgcAccess      access,
                FT_Bitmap* bitmap,
                FtCgcItem        cachedItem, FT_UInt glyphIndex, FTC_FaceID faceIdentifier, FT_Int fontHeight,
                FT_Int fontWidth);
            extern "C" void FtCustomGlyphCacheAccessFree( FtCgcAccess      access,
                FtCgcItem        item );
            extern "C" FT_UInt FtCustomGlyphCacheAccessCheck( FtCgcAccess      access,
                FtCgcItem        item );
            extern "C" void FtCustomGlyphCacheAccessDone( FtCgcAccess   access );

            GlyphBitmap::Format FtPixelModeToFormat(FT_Pixel_Mode pixelMode);


            /** @brief FT2 specific implementation of GlyphCacheAccess.
            Object from classes extending this interface shouldn't
            be destroyed before flushing the text engine cache.
            Failing to meet this requirement may result in undestoyed
            cache items.
            */
            class FtCustomGlyphCacheAccess {
            public:
                FtCustomGlyphCacheAccess();
                virtual ~FtCustomGlyphCacheAccess();

                /** 
                 * Creates a handle used to access data from the cache at a later time.
                 * The input bitmap contains a buffer stored in host memory. This buffer
                 * is not persistent, it may get destoyed after returning form calling this
                 * function. GlyphBitmap::pixels contains the address of this buffer.
                 *     @param bitmap   Glyph bitmap data.
                 *     @param cacheItem Existing handle for the current bitmap, if any.
                 *     @return         A handle that the application may use to access
                 *                     the glyph data.
                 */
                virtual UInt8* Create(const GlyphBitmap& bitmap, UInt8* cacheItem);

                /**
                 *  Destroys a handle used to access data from the cache.
                 *  @param buffer   A handle returned by Create.
                 */
                virtual void DestroyCacheItem(PixelBuffer buffer) = 0;

                /**
                 * Check wehter the current PixelBuffer is still valid (e.g. in current context).
                 */
                virtual bool CheckCacheItem(PixelBuffer buffer);

                /**
                 *  Release cached items related to this object.
                 */
                void ReleaseCache() const;

            private:
                FtCustomGlyphCacheAccess(const FtCustomGlyphCacheAccess& src);
                const FtCustomGlyphCacheAccess& operator = (const FtCustomGlyphCacheAccess& src);

                friend class FtGlyphRenderer;
                friend FT_Byte* FtCustomGlyphCacheAccessProcess( FtCgcAccess      access,
                    FT_Bitmap* bitmap,
                    FtCgcItem        cachedItem, FT_UInt glyphIndex, FTC_FaceID faceIdentifier, FT_Int fontHeight, FT_Int fontWidth);
                friend void FtCustomGlyphCacheAccessFree( FtCgcAccess      access,
                    FtCgcItem        item );
                friend FT_UInt FtCustomGlyphCacheAccessCheck(FtCgcAccess      access,
                    FtCgcItem        item );
                friend void FtCustomGlyphCacheAccessDone( FtCgcAccess   access );
                CANDERA_UNIT_TEST_CLASS_FRIEND(FtCustomGlyphCacheAccessTest);

                struct Base{
                    FtCgcAccessRec base;
                    FtCustomGlyphCacheAccess* client;
                };

                FtCgcAccess GetAccess() { return FeatStd::Internal::PointerToPointer<FtCgcAccess>(m_base); }

                Base* m_base;

                //void Copy(const FtCustomGlyphCacheAccess& src);
                //void Delete();
            };

            inline bool FtCustomGlyphCacheAccess::CheckCacheItem(PixelBuffer buffer) { FEATSTD_UNUSED(buffer); return true; }


            /** @} */ // end of FreetypeTextEngine

        }// namespace Internal
    }// namespace TextRendering
}// namespace Candera


#endif// Candera_FtCustomGlyphCacheAccess_h
