//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/TextEngine/FontStore.h>

namespace Candera {
    namespace TextRendering {

#ifndef CANDERA_DEPRECATED_3_2_0
#error GetFaceIndex shall become abstract.
#error GetDescriptorId with 2 parameters shall become abstract.
#else

        UInt8 Candera::TextRendering::FontStore::GetDescriptorId(const Char *name, UInt8 faceIndex)
        {
            FEATSTD_UNUSED(faceIndex);
            static bool isRecursive = false;
            if (isRecursive) {
                return 0; //The derived class should implement at least one virtual GetDescriptorId overload.
            }
            isRecursive = true;
            UInt8 result = GetDescriptorId(name, 0);
            isRecursive = false;
            return result;
        }

        UInt8 Candera::TextRendering::FontStore::GetFaceIndex(UInt8 descId)
        {
            FEATSTD_UNUSED(descId);
            return 0;
        }
#endif
    }
}
