//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/Environment.h>
//#define Candera_TextEngine_Include
#include <Candera/TextEngine/FontEngine.h>
#include "FeatStd/Util/StaticObject.h"

namespace Candera {
    namespace TextRendering {
        
        // ----------------------------------------------------------------------------
        FontEngine::FontEngine() :
            _init(false)
        {
        }

        // ----------------------------------------------------------------------------
        FontEngine& FontEngine::Instance()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(FontEngine,fontEngine);
            return fontEngine;
        }

        // ----------------------------------------------------------------------------
        bool FontEngine::Init(FontStore *fontStore)
        {
            if (!_init) {
                _init = FontEngineDefinition::FontEngine::Init(fontStore);
            }
            return _init;
        }

        // ----------------------------------------------------------------------------
        void FontEngine::Shutdown()
        {
            if (_init) {
                FontEngineDefinition::FontEngine::Shutdown();
                _init = false;
            }
        }

    }    // namespace TextRendering
}    // namespace Candera
