//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_CursorTextMeasureContext_h)
#define Candera_CursorTextMeasureContext_h

#include <Candera/TextEngine/TextMeasureContext.h>
#include <Candera/TextEngine/TextRect.h>

namespace Candera { namespace TextRendering { 
    class Style;

/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief CursorTextMeasureContext is used to measure the movement of the
 *  text cursor.
 *
 *  This class builds the smallest axis aligned rectangle that contains the
 *  the whole surface swept by the cursor when moving while processing the text.
 *  The cursor is considered to be a segment of length equal to the style
 *  height.
 *
 *  This class is best used when layout text, as the cursor of different
 *  texts are usually required to be aligned.
 */
class CursorTextMeasureContext : public TextMeasureContext {
public:
    /**
     * Constructor.
     * @param style Style from which font metrics are retrieved.
     * @param referenceContext Context to retrieve caching strategy from.
     */
    CursorTextMeasureContext(const Style& style, const TextRenderContext* referenceContext = 0);

    /**
     * Retrieve the rectangle computed by the context.
     * The rectangle is equal to TextRect() if nothing was measured.
     * @return The computed rectangle.
     */
    const TextRect& GetTextRectangle() const;

    /**
     * Retrieve the text direction of the last measured glyph.
     * @return The text direction.
     */
    GlyphBitmap::Direction GetLastDirection() const { return m_lastDirection; }
private:
    // Overrides function from TextMeasureContext.
    virtual void Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph) ;

    PixelPosition m_ascender;
    PixelPosition m_descender;

    TextRect m_textRectangle;
    GlyphBitmap::Direction m_lastDirection;
};

 /** @} */ // end of CanderaTextEngine

}// namespace TextRendering
}// namespace Candera

#endif// Candera_CursorTextMeasureContext_h
