//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CursorTextMeasureContext.h"
#include <Candera/TextEngine/Style.h>

namespace Candera { namespace TextRendering {

    CursorTextMeasureContext::CursorTextMeasureContext(const Style& style, const TextRenderContext* referenceContext) :
        TextMeasureContext(referenceContext),
        m_ascender(style.GetMetrics().ascender),
        m_descender(style.GetMetrics().descender),
        m_textRectangle(TextRect::GetMin()),
        m_lastDirection(GlyphBitmap::Implicit)
    {
    }

    void CursorTextMeasureContext::Measure(PixelPosition x, PixelPosition y, const GlyphBitmap &glyph)
        {
        // compute bounds
        PixelPosition left = x - glyph.left;
        PixelPosition right = left + glyph.xadvance;

        PixelPosition glyphBaseLine = y + glyph.top;
        PixelPosition top = (glyphBaseLine - m_ascender) + 1;
        PixelPosition bottom = glyphBaseLine - m_descender;

        m_textRectangle = m_textRectangle.Union(
            TextRect(left, top, right, bottom));
        m_lastDirection = glyph.direction;
    }

    const TextRect& CursorTextMeasureContext::GetTextRectangle() const
    {
        return m_textRectangle.IsNegative() ? TextRect::GetDefault() : m_textRectangle;
    }

    }    // namespace TextRendering
}    // namespace Candera
