//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_TextValidationEventHandling_h
#define Candera_TextEngine_TextValidationEventHandling_h

#include <FeatStd/Event/EventSource.h>
#include <FeatStd/Event/Event.h>
#include <FeatStd/Util/Rtti.h>
namespace Candera {
    class Node2D;
    namespace TextRendering {
        namespace Internal {

            /** @addtogroup CanderaTextEngine
            *  @{
            */
            class Node2DValidationEvent : public FeatStd::Event {
            public:
                FEATSTD_RTTI_DECLARATION();
                explicit Node2DValidationEvent(Candera::Node2D * node);
                Candera::Node2D * GetNode2D() const;
            protected:
                Candera::Node2D * m_node2d;
            };

            class TriggerValidationUpdateEvent : public FeatStd::Event {
            public:
                FEATSTD_RTTI_DECLARATION();
                explicit TriggerValidationUpdateEvent();
            };

            class TextValidationEventSources {
            public:
                static FeatStd::EventSource& GetDefaultValidationEventSource();
            };


            /** @} */ // end of CanderaTextEngine
        }//Internal
    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_TextValidationEventHandling_h
