//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextValidationEventSources.h"

#include <FeatStd/Util/StaticObject.h>
#include <FeatStd/Util/Rtti.h>
#include <FeatStd/Event/Event.h>
#include <Candera/Engine2D/Core/Node2D.h>

namespace Candera {
    namespace TextRendering {
        namespace Internal {

            Node2DValidationEvent::Node2DValidationEvent(Candera::Node2D * node) :m_node2d(node){}

            Candera::Node2D * Node2DValidationEvent::GetNode2D() const
            {
                return m_node2d;
            }

            TriggerValidationUpdateEvent::TriggerValidationUpdateEvent() {}

            FeatStd::EventSource& TextValidationEventSources::GetDefaultValidationEventSource()
            {
                FEATSTD_SYNCED_STATIC_OBJECT(FeatStd::EventSource, s_defaultEventSource);
                return s_defaultEventSource;
            }
            FEATSTD_RTTI_DEFINITION(Node2DValidationEvent, FeatStd::Event)
            FEATSTD_RTTI_DEFINITION(TriggerValidationUpdateEvent, FeatStd::Event)
        }
    }
}


