//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AsyncTextRenderDispatcher.h"
#include <FeatStd/Async/AsyncRequest.h>
#include <FeatStd/Async/AsyncRequestDispatcher.h>
#include <Candera/System/EntityComponentSystem/EntitySystem.h>
#include <Candera/System/EntityComponentSystem/EntityComponentSystem.h>

namespace Candera {
    namespace TextRendering {

        AsyncTextRenderDispatcher& AsyncTextRenderDispatcher::GetInstance()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(AsyncTextRenderDispatcher, instance);
            return instance;
        }

        FeatStd::AsyncRequestDispatcher * AsyncTextRenderDispatcher::GetDispatcher()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(FeatStd::AsyncRequestDispatcher, dispatcher, false, 1);
            return &dispatcher;
        }

        void AsyncTextRenderDispatcher::DispatchNextInternal()
        {
            UInt8 loopCnt = TextRenderDispatcher::GetTextRenderSettings().GetAsyncLoopCount();
            for (UInt8 i = 0; i < loopCnt; i++) {
                GetDispatcher()->DispatchNext(false);
            }
        }

        Candera::UpdateSystem::Delegate& AsyncTextRenderDispatcher::GetRenderDelegate()
        {
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1025, Candera::UpdateDelegate::Update, "False positive because the template arguments match.")
                static UpdateSystem::Delegate updateDelegate = UpdateSystem::Delegate::Update<AsyncTextRenderDispatcher, &AsyncTextRenderDispatcher::DispatchNextInternal>();
            return updateDelegate;
        }

        void AsyncTextRenderDispatcher::AttachDispatcher()
        {
            if (m_updateHandle.IsNullHandle()) {
                UpdateSystem* updateSystem = EntityComponentSystem::EntitySystem::Get<UpdateSystem>();
                FEATSTD_DEBUG_ASSERT(updateSystem != 0);
                if (updateSystem == 0) {
                    return;
                }
                m_updateHandle = updateSystem->CreateComponent();
                bool result = updateSystem->SetComponentLateUpdateDelegate(m_updateHandle, AsyncTextRenderDispatcher::GetRenderDelegate());
                result = result && updateSystem->AttachComponent(m_updateHandle, this);
                if (!result) {
                    static_cast<void>(updateSystem->DestroyComponent(m_updateHandle));
                    m_updateHandle = UpdateSystem::Handle();
                }
            }
        }

        void AsyncTextRenderDispatcher::DetachDispatcher()
        {
            if (m_updateHandle.IsNullHandle()) {
                return;
            }
            UpdateSystem* updateSystem = EntityComponentSystem::EntitySystem::Get<UpdateSystem>();
            if (updateSystem == 0) {
                return;
            }
            static_cast<void>(updateSystem->DetachComponent(m_updateHandle));
            static_cast<void>(updateSystem->DestroyComponent(m_updateHandle));
            m_updateHandle = UpdateSystem::Handle();
        }

        AsyncTextRenderDispatcher::~AsyncTextRenderDispatcher()
        {
            DetachDispatcher();
        }

        void AsyncTextRenderDispatcher::DispatchNext()
        {
            GetInstance().DispatchNextInternal();
        }

        bool AsyncTextRenderDispatcher::IsDispatcherEmpty()
        {
            if (GetDispatcher() == 0) {
                return true;
            }
            return GetDispatcher()->IsDispatcherEmpty();
        }

        AsyncTextRenderDispatcher::AsyncTextRenderDispatcher() :m_updateHandle()
        {
            AttachDispatcher();
        }

        void AsyncTextRenderDispatcher::WaitForHandleFinished(TextRenderHandle handle)
        {
            do {
                GetDispatcher()->DispatchNext(false);
            } while (!handle->IsCompleted());
        }

    }
}
