//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SYSTEM_H)
#define CANDERA_SYSTEM_H

// ControllerSystem
#include <Candera/System/ControllerSystem/ControllerComponent.h>
#include <Candera/System/ControllerSystem/ControllerSystem.h>

// Diagnostics
#include <FeatStd/Diagnostics/Debug.h>
#include <FeatStd/Diagnostics/ErrorHandling.h>
#include <Candera/System/Diagnostics/Log.h> // Retrieves FEATSTD_LOG_ENABLED!
#ifdef FEATSTD_LOG_ENABLED
    #include <FeatStd/Diagnostics/Appender.h>
    #include <FeatStd/Diagnostics/ConsoleAppender.h>
    #include <FeatStd/Diagnostics/FileAppender.h>
    #include <FeatStd/Diagnostics/LocationInfo.h>
    #include <FeatStd/Diagnostics/Logger.h>
    #include <FeatStd/Diagnostics/LogLevel.h>
    #include <Candera/System/Diagnostics/LogRealm.h>
#endif
#include <FeatStd/Diagnostics/SystemMemoryStatistic.h>
#include <Candera/System/Diagnostics/VideoMemoryStatistic.h>

// EntityComponentSystem
#include <Candera/System/EntityComponentSystem/EntityComponentSystem.h>

// GlobalizationBase
#include <Candera/System/GlobalizationBase/Culture.h>
#include <Candera/System/GlobalizationBase/CultureChangeListener.h>
#include <Candera/System/GlobalizationBase/CultureDataType.h>
#include <Candera/System/GlobalizationBase/CultureManager.h>
#include <Candera/System/GlobalizationBase/DefaultCultureManager.h>
#include <Candera/System/GlobalizationBase/LanguagePack.h>
#include <Candera/System/GlobalizationBase/Localizer.h>

// Mathematics
#include <Candera/System/Mathematics/Line.h>
#include <Candera/System/Mathematics/Math.h>
#include <Candera/System/Mathematics/MathDataTypes.h>
#include <Candera/System/Mathematics/Matrix3.h>
#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Mathematics/Plane.h>
#include <Candera/System/Mathematics/Rectangle.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <Candera/System/Mathematics/Vector4.h>

// Memory Management
#include <Candera/System/MemoryManagement/MemoryManagement.h>

// MetaInfo
#include <Candera/System/MetaInfo/DataType.h>
#include <Candera/System/MetaInfo/MetaInfo.h>
#include <Candera/System/MetaInfo/PublicMacros.h>
#include <Candera/System/MetaInfo/TypeAggregator.h>
#include <Candera/System/MetaInfo/TypeConverter.h>

// Monitor
#ifdef CANDERA_3D_ENABLED
#include <Candera/System/Monitor/GlobalExperimentPublicIF.h>  
#endif //CANDERA_3D_ENABLED
#include <Candera/System/Monitor/PerfMonPublicIF.h>         
#include <Candera/System/Monitor/MonitorPublicIF.h>

// Properties
#include <Candera/System/Properties/DisposableProperty.h>
#include <Candera/System/Properties/DisposablePropertyEx.h>
#include <Candera/System/Properties/SharedPtrProperty.h>
#include <Candera/System/Properties/SimpleProperty.h>
#include <Candera/System/Properties/SimplePropertyEx.h>

// Rtti
#include <Candera/System/Rtti/Rtti.h>

// UpdateSystem
#include <Candera/System/UpdateSystem/UpdateComponent.h>
#include <Candera/System/UpdateSystem/UpdateDelegate.h>
#include <Candera/System/UpdateSystem/UpdateSystem.h>

#endif    // CANDERA_SYSTEM_H
