//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SIMPLEPROPERTY_H)
#define CANDERA_SIMPLEPROPERTY_H

#include <Candera/Environment.h>

namespace Candera {

    /**
     *  @brief SimpleProperty is used for value and reference type properties.
     */
    template <typename T>
    class SimpleProperty {
        public:
            /**
             *  Constructor
             */
            SimpleProperty();

            /**
             *  Constructor
             *  @param value The value that is assigned.
             */
            SimpleProperty(const T& value);

            /**
             *  Destructor
             */
            ~SimpleProperty();

            /**
             *  Sets the value.
             *  @param value The value that is assigned.
             */
            void Set(const T& value);

            /**
             *  Gets the current value.
             *  @return The current value.
             */
            const T& Get() const;

            /**
             *  Gets the current value.
             *  @return The current value.
             */
            T& Get();

            operator T();
            operator const T() const;

            T& operator()();
            const T& operator()() const;

            const T& operator=(const T& value);

        private:
            T m_value;

            FEATSTD_MAKE_CLASS_UNCOPYABLE(SimpleProperty);
    };

    template<typename T>
    SimpleProperty<T>::SimpleProperty() :
        m_value(T())
    {
    }

    template<typename T>
    SimpleProperty<T>::SimpleProperty(const T& value) :
        m_value(value)
    {
    }

    template<typename T>
    SimpleProperty<T>::~SimpleProperty()
    {
    }

    template<typename T>
    inline void SimpleProperty<T>::Set(const T& value)
    {
        m_value = value;
    }

    template<typename T>
    inline const T& SimpleProperty<T>::Get() const
    {
        return m_value;
    }

    template<typename T>
    inline T& SimpleProperty<T>::Get()
    {
        return m_value;
    }

    template<typename T>
    inline SimpleProperty<T>::operator T()
    {
        return Get();
    }
    
    template<typename T>
    inline SimpleProperty<T>::operator const T() const
    {
        return Get();
    }

    template<typename T>
    inline T& SimpleProperty<T>::operator()()
    {
        return Get();
    }
    
    template<typename T>
    inline const T& SimpleProperty<T>::operator()() const
    {
        return Get();
    }

    template<typename T>
    const T& SimpleProperty<T>::operator=(const T& value)
    {
        Set(value);
        return m_value;
    }

}   // namespace Candera

#endif  // CANDERA_SIMPLEPROPERTY_H
