//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef PerfMonPublicIF_H
    #define PerfMonPublicIF_H

#ifdef FEATSTD_MONITOR_ENABLED
    #if defined(CANDERA_PERFCOUNTER_NOT_SUPPORTED)
        #error Needed for counters: Disable MONITOR on this platform
    #endif

    #include <FeatStd/Monitor/MonitorPausedSynchronization.h>
    #include <FeatStd/Monitor/PerformanceRecording/PerformanceRecording.h>
    // Don't use in Candera code
    #define CANDERA_PERF_SET_ENABLED(enable) \
                FeatStd::PerfMon::Internal::ResetState(true);\
                FeatStd::PerfMon::ResetRecordingState(false); \
                FeatStd::PerfMon::Controller::SetEnabled(enable)
#else // !defined FEATSTD_MONITOR_ENABLED
    #define CANDERA_PERF_SET_ENABLED(enable)
#endif

#ifdef _lint
    #define MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED
#endif

#if defined(FEATSTD_MONITOR_ENABLED) && defined(MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED)
    namespace Candera {

        namespace PerfMon {
            namespace TimingRecId {
                using namespace FeatStd::PerfMon::TimingRecId;
            }

            namespace AsyncTimingRecId {
                using namespace FeatStd::PerfMon::AsyncTimingRecId;
            }

            namespace ValueRecId {
                using namespace FeatStd::PerfMon::ValueRecId;
            }

            namespace EventRecId {
                using namespace FeatStd::PerfMon::EventRecId;
            }

            typedef FeatStd::PerfMon::Controller ControlPanel;
        }
    }

    #define CANDERA_PERF_RECORDER(type, ctorArgs) \
        FeatStd::PerfMon::FEATSTD_CONCAT2(type, Recorder) FEATSTD_CONCAT2(perfRec, __LINE__) ctorArgs

    #define CANDERA_PERF_RECORD_EVENT(eventRecId) \
        FeatStd::PerfMon::RecordEvent(eventRecId)
    #define CANDERA_PERF_RECORD_ANNOTATED_EVENT(valueRecId, annotation) \
        FeatStd::PerfMon::RecordEvent(valueRecId, annotation)
    #define CANDERA_PERF_RECORD_VALUE(valueRecId, value) \
        FeatStd::PerfMon::RecordValue(valueRecId, value)
    #define CANDERA_PERF_ASYNCREC_FINISHED(aSyncTimingRecId) \
        FeatStd::PerfMon::AsyncTimingRecorder::OnAsyncOpFinished(aSyncTimingRecId)

    #define CANDERA_PERF_DUMP_DATA(pDumpFunc, force, userData) \
        FeatStd::PerfMon::Controller::DumpPerfData(pDumpFunc, force, userData)


    /**
    * When more than one thread use recorder, a synchronization bridge between all threads using a recorder has to be used.
    * There is one macro (CANDERA_PERF_COLLECT_RECORDING_THREAD_SYNC_BARRIER) for the monitor worker thread which collects and sends/process the data from recorder (consumer),
    * and another macro (CANDERA_PERF_PRODUCE_RECORDING_THREAD_SYNC_BARRIER) for all the other threads (producer of recordings).
    * The consumer thread can also be used for recordings (equal to old implementation).
    *
    * Using the consumer macro is similar to fire an event and blocks until all other threads are synced. All producer threads will be blocked until
    * the scope of the consumer macro has been left.
    * To sync all other threads use the producer macro. The correct place is the scope surrounding all recordings within a thread.
    * It is advised to do so to avoid incomplete recordings when the data is processed (and eventually deleted from memory).
    * NOTE: A sync barrier means it is blocking until all other threads reached their barrier counterpart. It is possible to deadlock with other
    * sync barriers due to their nature of blocking.
    *
    * This macro is the producer macro.
    */
    #define CANDERA_PERF_PRODUCE_RECORDING_THREAD_SYNC_BARRIER()\
        FeatStd::PerfMon::Internal::MonitorPausedAnyThread anyThread(FeatStd::PerfMon::Internal::MonitorPausedSynchronization::GetInstance())

    /**
    * When more than one thread use recorder, a synchronization bridge between all threads using a recorder has to be used.
    * There is one macro (CANDERA_PERF_COLLECT_RECORDING_THREAD_SYNC_BARRIER) for the monitor worker thread which collects and sends/process the data from recorder (consumer),
    * and another macro (CANDERA_PERF_PRODUCE_RECORDING_THREAD_SYNC_BARRIER) for all the other threads (producer of recordings). 
    * The consumer thread can also be used for recordings (equal to old implementation).
    * 
    * Using the consumer macro is similar to fire an event and blocks until all other threads are synced. All producer threads will be blocked until
    * the scope of the consumer macro has been left.
    * To sync all other threads use the producer macro. The correct place is the scope surrounding all recordings within a thread.
    * It is advised to do so to avoid incomplete recordings when the data is processed (and eventually deleted from memory).
    * NOTE: A sync barrier means it is blocking until all other threads reached their barrier counterpart. It is possible to deadlock with other 
    * sync barriers due to their nature of blocking.
    *
    * This macro is the consumer macro.
    */
    #define CANDERA_PERF_COLLECT_RECORDING_THREAD_SYNC_BARRIER()\
        FeatStd::PerfMon::Internal::MonitorPausedThread monitorWorkerThread(FeatStd::PerfMon::Internal::MonitorPausedSynchronization::GetInstance())
      

#else // !defined FEATSTD_MONITOR_ENABLED && ...
    #define CANDERA_PERF_RECORDER(type, ctorArgs)

    #define CANDERA_PERF_RECORD_EVENT(eventRecId)
    #define CANDERA_PERF_RECORD_ANNOTATED_EVENT(eventRecId, annotation)
    #define CANDERA_PERF_RECORD_VALUE(valueRecId, value)
    #define CANDERA_PERF_ASYNCREC_FINISHED(aSyncTimingRecId)
    #define CANDERA_PERF_DUMP_DATA(pFn, force, userData) false

    #define CANDERA_PERF_PRODUCE_RECORDING_THREAD_SYNC_BARRIER()
    #define CANDERA_PERF_COLLECT_RECORDING_THREAD_SYNC_BARRIER()

#endif


#endif
