//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef GlobalExperimentPublicIF_H
#define GlobalExperimentPublicIF_H

#ifdef FEATSTD_MONITOR_ENABLED

#include <CanderaMonitor/Experiment/GlobalExperiment.h>

#define GLOBAL_EXPERIMENT_COND_IGNORE_DRAW_CALL \
    if (Candera::Monitor::GlobalExperiment3D::GetInstance().IgnoreDrawCalls()) { \
        return true; \
        }
#define GLOBAL_EXPERIMENT_COND_IGNORE_DRAW_CALL_2D \
    if (Candera::Monitor::GlobalExperiment2D::GetInstance().IgnoreDrawCalls()) { \
        return true; \
        }

#define GLOBAL_EXPERIMENT_COND_USE_DEFAULT_SHADER_INSTEAD_OF(shaderProgramHandle) \
    { \
        Candera::Monitor::GlobalExperiment3D& globalExperiment = Candera::Monitor::GlobalExperiment3D::GetInstance(); \
        \
        if (globalExperiment.IsNullShaderEnabled()) { \
            shaderProgramHandle = globalExperiment.GetNullShaderProgramHandle(); \
        } \
    }

#define GLOBAL_EXPERIMENT_COND_ACTIVATE_DEFAULT_TEXTURE_IMAGE \
    { \
        Candera::Monitor::GlobalExperiment3D& globalExperiment = Candera::Monitor::GlobalExperiment3D::GetInstance(); \
        \
        if (globalExperiment.Is2x2TextureEnabled()) { \
            return UpdateTextureBinding(globalExperiment.GetNullTexture()->GetTextureImage()->GetVideoMemoryHandle(), \
                                        unit, \
                                        globalExperiment.GetNullTexture()->GetTextureImage()->GetTextureTargetType()); \
        } \
    }

#define GLOBAL_EXPERIMENT_COND_ACTIVATE_DEFAULT_SHADER \
    { \
        Candera::Monitor::GlobalExperiment3D& globalExperiment = Candera::Monitor::GlobalExperiment3D::GetInstance(); \
        \
        if (globalExperiment.IsNullShaderEnabled()) { \
            Handle program = globalExperiment.GetNullShaderProgramHandle(); \
            if (program != 0) \
            { \
                CANDERA_RENDERDEVICE_OPENGL_RECORDER(glUseProgram); \
                glUseProgram(static_cast<GLuint>(program)); \
            } \
            return true; \
        } \
    }

#ifdef MONITOR_CANDERA_CUSTOM_EXPERIMENTS
/** <em>GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST</em> is used to initialize custom experiments.
    @param functionCount    Count of function-pointers
    @param ...              function-pointers of type: void (*customExperiment)(bool)
    The boolean parameter of function-pointer is used for the enabled (true) and disabled (false) state of the custom experiment.
    Per default the boolean parameter is false.
    Calling a registered function has to be done with using the macro <em>GLOBAL_EXPERIMENT_CALL_CUSTOM_EXPERIMENT</em> otherwise undefined behavior can occur.

    Note: Calling <em>GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST</em> is only allowed for a single time!*/
#define GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST(functionCount, ...) \
        GLOBAL_EXPERIMENT_INTERNAL_INIT_CUSTOM_LIST(functionCount,__VA_ARGS__);

/** <em>GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST</em> is used to call a custom experiment function with given parameter.
    If value is the current value then no call is done. Function is only called by value change.
    Use this function to call fct_ptr without unknown/unwanted side effects
*/
#define GLOBAL_EXPERIMENT_CALL_CUSTOM_EXPERIMENT(fct_ptr, value)\
    Candera::Monitor::GlobalExperiment::GetInstance().SetParameterByFct(fct_ptr,value)

#else

#define GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST(functionCount, ...) 
#define GLOBAL_EXPERIMENT_CALL_CUSTOM_EXPERIMENT(fct_ptr, value)  false

#endif

#else // !defined FEATSTD_MONITOR_ENABLED

#define GLOBAL_EXPERIMENT_COND_IGNORE_DRAW_CALL_2D
#define GLOBAL_EXPERIMENT_COND_IGNORE_DRAW_CALL
#define GLOBAL_EXPERIMENT_COND_USE_DEFAULT_SHADER_INSTEAD_OF(shaderProgramHandle)
#define GLOBAL_EXPERIMENT_COND_ACTIVATE_DEFAULT_TEXTURE_IMAGE
#define GLOBAL_EXPERIMENT_COND_ACTIVATE_DEFAULT_SHADER
#define GLOBAL_EXPERIMENT_INIT_CUSTOM_LIST(functionCount, ...) 
#define GLOBAL_EXPERIMENT_CALL_CUSTOM_EXPERIMENT(fct_ptr, value)  false

#endif



#endif
