//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_OBJECTMETAINFOSET_H)
    #define CANDERA_OBJECTMETAINFOSET_H

#include <Candera/System/MetaInfo/MetaInfoBase.h>

namespace Candera { namespace MetaInfo {
/// @addtogroup MetaInfo
/// @{


template<typename T>
class PropertyMetaInfo;

template<typename T, typename P>
class ObjectMetaInfo;

template<typename T, typename O = ObjectMetaInfo<T, PropertyMetaInfo<T> > >
class ObjectMetaInfoSet: public MetaInfoBase
{
    public:
        /**
            *  Constructs object with given name.
            *  @param name Name to assign to ObjectMetaInfo object.
            */
        ObjectMetaInfoSet(const Char *name) : MetaInfoBase(name) { }

        /**
            *  Destructor
            */
        virtual ~ObjectMetaInfoSet() {}

        /**
            *  Retrieves the meta information object of the given widget property
            *  Properties inherited by the base class are contained in this
            *  lookup.
            *  @param name name of the property
            *  @return pointer to the PropertyMetaInfo object, null if the property does not exist
            */
        virtual O* LookupItem(const Char *name) const = 0;

        /**
            *  retrieve meta information object of the property at given index
            *  Properties inherited by the base class are contained in this
            *  enumeration.
            *  @param idx index of the property
            *  @return pointer to the meta information object
            */
        virtual O* GetItem(Int32 idx) const = 0;

        /**
            *  Gives the number of properties in the widget
            *  The number includes properties inherited by base class widget
            *  @return number of properties in the widget
            */
        virtual Int32 GetItemCount() const = 0;

        /**
         * Retrieve ObjectSet version.
         * @return version.
         */
        virtual Int32 GetVersion() const = 0;
};

/**
 * Method to retrieve an ObjectSet
 */
template <typename T>
ObjectMetaInfoSet<T>* GetObjectSet();

/// @}
}}
#endif
