//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(INTERNAL_MACROS_H)
#define INTERNAL_MACROS_H

#include <Candera/System/MetaInfo/BaseInternalMacros.h>
#include <Candera/System/MetaInfo/PropertyMetaInfoAnimationPropertySetters.h>

namespace Candera {
    namespace Internal {
    template<typename HostType, bool DoCreate> struct Exposer {
        /** expose HostType::CMI */
        typedef typename HostType::template CMI<DoCreate> CMI;
        template<typename T>
        static T GetMetaInfo(const HostType& host)
        {
            return host.GetMetaInfo();
        }

        template<typename T>
        static T GetMetaInfoImpl()
        {
            return HostType::GetMetaInfoImpl();
        }

#ifdef CANDERA_META_DESCRIPTION
        template<typename T1, typename T2>
        static T1 GetEvents()
        {
            T2 metaInfo = GetMetaInfoImpl<T2>();
            if (0 != metaInfo) {
                return metaInfo->GetEvents();
            }
            return 0;
        }
#endif
    };
    template<typename HostType> struct ExposerDoCreate {
        /** expose HostType::CMI */
        typedef typename Exposer<HostType, true>::CMI CMI;
    };
}
}

/*  ----------------------------------------------------------------------------
    Internal macros
    ---------------------------------------------------------------------------- */

/* Cast operator declaration */
#define _CdaTypeStrictStaticCastOperator() \
    static CurrentType* CdaCastOperator(BaseHostType* object, const CurrentType*) { \
        CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1774, safe) \
        return static_cast<CurrentType*>(object); \
    } \
    static const CurrentType* CdaCastOperator(const BaseHostType* object, const CurrentType*) { \
        CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1774, safe) \
        return static_cast<const CurrentType*>(object); \
    }

#define _CdaInheritedTypeStaticCastOperator(CastType) \
    static CastType* CdaCastOperator(BaseHostType* object, const CastType*) { \
        return InjectedTypeProperties::CdaCastOperator(object, (CurrentType*)0); \
    } \
    static const CastType* CdaCastOperator(const BaseHostType* object, const CastType*) { \
    return InjectedTypeProperties::CdaCastOperator(object, (CurrentType*)0); \
    }

#define _CdaStructureTypeStaticCastOperator(CastType, FieldName) \
    static CastType* CdaCastOperator(BaseHostType* object, const CastType*) { \
        return &InjectedTypeProperties::CdaCastOperator(object, (CurrentType*)0)->FieldName; \
    } \
    static const CastType* CdaCastOperator(const BaseHostType* object, const CastType*) { \
    return &InjectedTypeProperties::CdaCastOperator(object, (CurrentType*)0)->FieldName; \
    }

#define _CdaTypeCastDeclaration() \
    _CdaInheritedTypeStaticCastOperator(CurrentType)

/*  ----------------------------------------------------------------------------
    Module use macros
    ---------------------------------------------------------------------------- */

/* Meta info declaration */

/**
 *  Internal macro - opens the declaration of a template meta information class.
 *  This is used by injected types to set properties to current type objects.
 *  This is provided to use with objects that are not of type GlobalBaseType,
 *  but are part of hierarchy that allows proper casting from GlobalBaseType to CurrentType.
 *  (i.e. via common child type.
 *   @param Type                    type to which to attach the meta information
 *   @param TypeName                readable name of type to which to attach the meta information
 *   @param GlobalBaseType          base type for all objects using this chain of meta information objects
 *                                  (i.e. base type of type named TypeName and of type CdaTInjectedType)
 *   @param MetaInfoName            name of the meta info object generated for this class
 *   @param BaseMetaInfoClass        base class for this meta information class
 */
#define _CdaMetaInfoTemplateObjectProlog(Type, TypeName, GlobalBaseType, MetaInfoName, BaseMetaInfoClass) \
    /*lint -save -e578*/ \
    public: \
    template<typename CdaTInjectedMetaInfo> \
    class FEATSTD_CONCAT2(MetaInfoName, Template) : public BaseMetaInfoClass { \
        public: \
        struct Properties; \
        typedef FEATSTD_CONCAT2(MetaInfoName, Template)<CdaTInjectedMetaInfo> CurrentMetaInfo; \
        typedef Type CurrentType; \
        typedef CdaTInjectedMetaInfo InjectedMetaInfo; \
        typedef BaseMetaInfoClass BaseMetaInfoType; \
        typedef GlobalBaseType BaseHostType; \
        FEATSTD_CONCAT2(MetaInfoName, Template)(const Candera::Char *name) : BaseMetaInfoType(name) { } \
        FEATSTD_CONCAT2(MetaInfoName, Template)() : BaseMetaInfoType(FEATSTD_STRINGIZE(TypeName)) { }

/**
 *  Internal macro - opens the declaration of a meta information class.
 *  This creates a template class and a specialization for setting properties to a
 *  Current Type object.
 *   @param Type                    type to which to attach the meta information
 *   @param TypeName                readable name of type to which to attach the meta information
 *   @param GlobalBaseType          base type for all objects using this chain of meta information objects
 *                                  (i.e. base type of type named TypeName and of type CdaTInjectedType)
 *   @param MetaInfoName            name of the meta info object generated for this class
 *   @param BaseMetaInfoClass        base class for this meta information class
 */
#define _CdaMetaInfoObjectProlog(Type, TypeName, GlobalBaseType, MetaInfoName, BaseMetaInfoClass) \
    /*lint -save -e578*/ \
    public: \
    class FEATSTD_CONCAT2(MetaInfoName, TemplateBase){ \
        public: \
        typedef Type CurrentType; \
        typedef GlobalBaseType BaseHostType; \
        struct Properties { \
            _CdaTypeStrictStaticCastOperator() \
        }; \
    }; \
    template<typename CdaTInjectedType> \
    class FEATSTD_CONCAT2(MetaInfoName, Template); \
    CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1516, CANDERA_LINT_REASON_WIDGET_CDAMETAINFO) \
    typedef FEATSTD_CONCAT2(MetaInfoName, Template)<FEATSTD_CONCAT2(MetaInfoName, TemplateBase)> MetaInfoName; \
    CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(665, CANDERA_LINT_REASON_NO_PARENTHESES_ALLOWED)\
    _CdaMetaInfoTemplateObjectProlog(Type, TypeName, GlobalBaseType, MetaInfoName, BaseMetaInfoClass)

/**
 *  Internal macro - closes the declaration of a meta information class.
 */
#define _CdaMetaInfoObjectEpilog() \
    /*lint -restore*/ \
    };


#define _CdaMetaInfoObjectBase(type) \
    struct type##DefaultMetaInfo { \
        _CdaMetaInfoObjectProlog(type##DefaultMetaInfo, type##DefaultMetaInfo, type##DefaultMetaInfo, CdaMetaInfo, Candera::MetaInfo::ObjectMetaInfo<PointerToBaseTypeForMetaInfo>) \
        struct Properties { \
            typedef MetaInfo::NullAggregatable<MetaInfo::PropertyMetaInfo<type> > ItemAggregation; \
        }; \
        virtual MetaInfo::PropertyMetaInfo<type>* LookupItem(const Char *) const { return 0; } \
        virtual MetaInfo::PropertyMetaInfo<type>* GetItem(Int32) const { return 0; } \
        virtual Int32 GetItemCount() const { return 0; } \
        virtual PointerToBaseTypeForMetaInfo Create() { return PointerToBaseTypeForMetaInfo(); } \
        _CdaMetaInfoObjectEpilog() \
    }; \

/**
 *  Internal macro - defines hash interface for an aggregation type
 *  @param containerType typed AggregationContainer type name
 */
#define _CdaMetaInfoHashInterface(aggregationName) \
    FEATSTD_LINT_NEXT_EXPRESSION(1058, "False positive: Not 'Candera::WidgetBase::GetName(void) const' is called, but 'Candera::MetaInfo::MetaInfoBase::GetName()'.") \
    FEATSTD_LINT_NEXT_EXPRESSION(64, "False positive: 'this' (struct 'Widgets' inside WidgetsSet) is not of type 'Candera::WidgetBase'.") \
    virtual Candera::UInt32 GetHash() const { return Candera::MetaInfo::Internal::Fnv1aHash::MixHash(Candera::MetaInfo::Internal::Fnv1aHash::Hash(GetName()), aggregationName::Aggregation::GetHash()) & 0x7FFFFFFFU; }

/* Meta info properties */
/* These macros should only be used between _CdaMetaInfoObjectProlog and _CdaMetaInfoObjectEpilog */

/**
 *  Internal macro - defines a null base for the property set.
 *                   This macro is provided to allow old style property inheritance from base class.
 *  @param BasePropertyType        base type for each property
 */
#define _CdaDefaultPropertyBase(BasePropertyType) \
    typedef Candera::MetaInfo::NullAggregatable<BasePropertyType> BaseMetaInfoProperties; \
    typedef void _BaseCastType;

/**
 *  Internal macro - defines an inherited base for the property set.
 *                  This macro is provided to allow old style property inheritance from base class.
 *  @param BaseType                base type from which to inherit properties.
 *  @param MetaInfoName            name of the meta info object generated for this class
 */
#define _CdaInheritedPropertyBase(BaseType, MetaInfoName) \
    typedef typename BaseType::FEATSTD_CONCAT2(MetaInfoName, Template)<CurrentMetaInfo>::Properties::ItemAggregation \
        PredefinedBaseTypeImportedProperties; \
    typedef BaseType PredefinedBaseType;

/**
 *  Internal macro - creates a meta info base class name, based on the base class for CurrentType
 *                  and the meta info name.
 *  @param BaseType                type of the base class
 *  @param MetaInfoName            name of the meta info object generated
 */
#define _CdaGenericMetaInfoBaseClass(BaseType, MetaInfoName) \
    BaseType::MetaInfoName
    //BaseType::FEATSTD_CONCAT2(MetaInfoName, Template)<CdaTInjectedType>

/* Property set declaration */
/* These macros should only be used between _CdaMetaInfoObjectProlog and _CdaMetaInfoObjectEpilog */

/**
 *  Internal macro - opens the declaration of a property set.
 */
#define _CdaPropertySetProlog(PropertyType) \
    typedef PropertyType BasePropertyType; \
    typedef Candera::MetaInfo::NullAggregatable<BasePropertyType> BaseMetaInfoProperties; \
    typedef typename InjectedMetaInfo::Properties InjectedTypeProperties; \
    _CdaAggregationProlog(Properties, BasePropertyType, BaseMetaInfoProperties, _CdaTypeCastDeclaration())

/**
 *  Internal macro - closes the declaration of a property set.
 */
#define _CdaPropertySetEpilog() \
    _CdaAggregationEpilog(Properties, typename Properties) \
    _CdaMetaInfoHashInterface(Properties)

/* Property declaration */
/* These macros should only be used between _CdaPropertySetProlog and _CdaProperySetEpilog */

/**
 *  Internal macro - opens the declaration of a property.
 *  @param PropertyName        name of this property.
 *  @param PropertyType        type of this property.
 */
#define _CdaPropertyProlog(Name, Type) \
    _CdaAggregationItemProlog(Name) \
    typedef Type TPropertyType; \
    typedef const Candera::Char * SetterValueType; \
    _CdaDataTypeEditorInfo(Type) \
    _CdaDimensions(Type) \
    _CdaHash(Name, Type)

/** Opens a property definition section within a properties definition section. @see CdaProperties
    @param name name of the property (e.g. TextColor)
    @param type type of the property (e.g. Color) */
#define _CdaFieldPropertyDef(name, type, prop) \
    _CdaPropertyProlog(name, type) \
    _CdaFieldProperty(prop) \
    _CdaDirectAPSFactory(name, prop)

/**
 *  Internal macro - closes the declaration of a property.
 */
#define _CdaPropertyEpilog() \
    _CdaEditorInfoChooser() \
    _CdaAggregationItemEpilog(typename)

/* Property manipulation */
/* These macros should only be used between _CdaPropertySetProlog and _CdaProperySetEpilog */

/**
 *  Internal macro - imports to the current property set the properties from a member of
 *                  a CurrentType object.
 *  @param ClientName        name of the member type.
 *  @param ClientType        type of the member.
 *  @param ClientField       name of the member.
 *  @param MetaInfoName      name of the meta info object
 */
#define _CdaStructureImportProperties(ClientName, ClientType, ClientField, MetaInfoName) \
    _CdaUniqueName(ClientName); \
    _CdaStructureTypeStaticCastOperator(ClientType, ClientField); \
    typedef typename ClientType::FEATSTD_CONCAT2(MetaInfoName, Template)<CurrentMetaInfo>::Properties::ItemAggregation \
        FEATSTD_CONCAT2(ClientItemAggregation, _CdaUniqueName(ClientName)); \
    _CdaTypedefAggregator(_CdaUniqueName(ClientName), FEATSTD_CONCAT2(ClientItemAggregation, _CdaUniqueName(ClientName)))

/**
 *  Internal macro - imports to the current property set the properties from a base class of
 *                  CurrentType.
 *  @param ClientName        name of the member type.
 *  @param ClientType        type of the member.
 *  @param MetaInfoName      name of the meta info object
 */
#define _CdaBaseClassImportProperties(ClientName, ClientType, MetaInfoName) \
    _CdaUniqueName(ClientName); \
    _CdaInheritedTypeStaticCastOperator(ClientType); \
    typedef typename ClientType::FEATSTD_CONCAT2(MetaInfoName, Template)<CurrentMetaInfo>::Properties::ItemAggregation \
        FEATSTD_CONCAT2(ClientItemAggregation, _CdaUniqueName(ClientName)); \
    _CdaTypedefAggregator(_CdaUniqueName(ClientName), FEATSTD_CONCAT2(ClientItemAggregation, _CdaUniqueName(ClientName)))

/**
 *  Internal macro - imports to the current property set the properties from a base class of
 *                  CurrentType, as defined by one of the _Cda*PropertyBase macros.
 *  @param MetaInfoName      name of the meta info object
 */
#define _CdaPredefinedBaseClassImportProperties(MetaInfoName) \
    PredefinedBaseTypeBefore; \
    _CdaInheritedTypeStaticCastOperator(PredefinedBaseType); \
    _CdaTypedefAggregator(PredefinedBaseTypeBefore, PredefinedBaseTypeImportedProperties)

/* Property setters/getters */
/* These macros should only be used between _CdaPropertyProlog and _CdaPropertyEpilog */
/* Inherited internal names:
 * BaseHostType from Property Set
 * _CastOperatorType from Cast Operator
 * TPropertyType from Property
 * SetterValueType from Property
 */

/**
 *  Internal macro - creates a method for setting values to a property.
 *  @param setter name of the method form CurrentType used for setting the converted value.
 */
#define _CdaPropSetter(setter) \
    virtual bool Set(BaseHostType *object, SetterValueType value) { \
        TPropertyType propVal; \
        propVal = TPropertyType(); \
        bool ok = Candera::MetaInfo::Internal::DataType<TPropertyType>::ConvertFromString(propVal, value); \
        if (ok) { \
            CdaCastOperator(object, (CurrentType*)0)->setter(propVal); \
        } \
        return ok; \
    }

#define _CdaDirectAPSFactory(name, prop) \
    virtual Candera::Animation::AnimationPropertySetter::SharedPointer CreateAnimationPropertySetter(BaseHostType* object, Candera::Int dataSize, Candera::Int* channels) { \
        return Candera::Internal::DAPSFactory<BaseHostType, TPropertyType, static_cast<PropertyMetaInfoBase::UpdateType>(c_updateType)>::Create(CdaCastOperator(object, (CurrentType*)0)->prop, object, dataSize, channels, FEATSTD_STRINGIZE(name)); \
    }

#define _CdaIndirectAPSFactory(name, setter, getter) \
    template<typename T> class name##PropertySetter: public Candera::Internal::ObjectPropertySetter<BaseHostType> { \
    public: \
        name##PropertySetter(BaseHostType* object, Candera::Int dataSize, const Candera::Int* channels): \
            Candera::Internal::ObjectPropertySetter<BaseHostType>(object), \
            m_channelData(dataSize, channels) \
            { \
                Candera::Internal::ObjectPropertySetter<BaseHostType>::SetPropertyName(#name); \
            } \
        virtual void Set(const Candera::Float* value) { \
            CurrentType* const object = CdaCastOperator(GetAnimatedObject(), (CurrentType*)0); \
            T propObj = static_cast<T>(object->getter()); \
            Candera::FloatConverter<T>::Get(propObj, value, m_channelData.GetChannels()); \
            object->setter(propObj); \
        } \
    private: \
        Candera::Internal::MultiChannelData<Candera::FloatConverter<T>::Size> m_channelData; \
    }; \
    virtual Candera::Animation::AnimationPropertySetter::SharedPointer CreateAnimationPropertySetter(BaseHostType* object, Candera::Int dataSize, Candera::Int* channels) { \
    return Candera::Internal::IAPSFactory<BaseHostType, TPropertyType, name##PropertySetter, static_cast<PropertyMetaInfoBase::UpdateType>(c_updateType)>::Create(object, dataSize, channels); \
    };

/**
 *  Internal macro - creates a method for getting values from a property.
 *  @param getter name of the method form CurrentType used for getting the converted value.
 */
#define _CdaPropGetter(getter) \
    virtual bool Get(const BaseHostType *object, Candera::Char *buf, Candera::UInt buf_size) { \
        return Candera::MetaInfo::Internal::DataType<TPropertyType>::ConvertToString(static_cast<TPropertyType>(CdaCastOperator(object, (CurrentType*)0)->getter()), buf, buf_size); \
    }

/**
*  Internal macro - creates method for setting a property object.
*  @param prop name of the member object form CurrentType used for setting the converted value.
*/
#define _CdaFieldPropertySet(prop) \
    template <typename P> static inline bool ConvertFromString(P& property, SetterValueType value) { \
        return Candera::MetaInfo::Internal::DataType<P>::template ConvertFromString<TPropertyType>(property, value); \
    } \
    virtual bool Set(BaseHostType* object, SetterValueType value) { \
        return ConvertFromString(CdaCastOperator(object, (CurrentType*)0)->prop, value); \
    }

/**
*  Internal macro - creates method for getting a property object.
*  @param prop name of the member object form CurrentType used for getting the converted value.
*/
#ifdef CANDERA_META_DESCRIPTION
#define _CdaFieldPropertyGet(prop) \
    template <typename P> static inline bool ConvertToString(const P& property, Candera::Char* buf, Candera::UInt buf_size) { \
        return Candera::MetaInfo::Internal::DataType<P>::template ConvertToString<TPropertyType>(property, buf, buf_size); \
    } \
    virtual bool Get(const BaseHostType* object, Candera::Char* buf, Candera::UInt buf_size) { \
        return ConvertToString(CdaCastOperator(object, (const CurrentType*)0)->prop, buf, buf_size); \
    }
#else
#define _CdaFieldPropertyGet(prop) \
    virtual bool Get(const BaseHostType* , Candera::Char* , Candera::UInt) { \
        return false; \
    }
#endif

/**
*  Internal macro - creates methods for setting/getting values to/from a property object.
*  @param prop name of the member object form CurrentType used for setting/getting the converted value.
*/
#define _CdaFieldProperty(prop) \
    _CdaFieldPropertySet(prop) \
    _CdaFieldPropertyGet(prop)

/* Property options */
/* These macros should only be used between _CdaPropertyProlog and _CdaPropertyEpilog */

/**
 *  Internal macro - create a method for retrieving a property editor string.
 *  @param PropType        the type of the property.
 */
#ifdef CANDERA_META_DESCRIPTION
    #define _CdaDataTypeEditorInfo(PropType) \
        CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1916,"Only used on host.") \
        CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1411,"Only used on host.") \
        static const Candera::Char* GetEditor(...) { return Candera::MetaInfo::Internal::DataType<PropType>::GetEditor(); }
    #define _CdaCustomEditorInfo(EditorString) \
        static const Candera::Char* GetEditor(Candera::Int) { return EditorString; }
    #define _CdaEditorInfoChooser() \
        virtual const Candera::Char* GetEditor() const { return GetEditor(static_cast<Candera::Int>(0)); }
#else
    #define _CdaDataTypeEditorInfo(PropType)
    #define _CdaCustomEditorInfo(EditorString)
    #define _CdaEditorInfoChooser()
#endif

/**
 *  Internal macro - create a method for retrieving the number of property dimensions.
 *  @param PropType        the type of the property.
 */
#ifdef CANDERA_META_DESCRIPTION
    #define _CdaDimensions(PropType) \
        virtual Candera::UInt8 GetDimensionCount() const { return static_cast<Candera::UInt8>(Candera::MetaInfo::DataTypeDimensions<PropType>::Count); }
#else
    #define _CdaDimensions(propType)
#endif

#define _CdaHash(PropertyName, PropertyType) \
    virtual Candera::UInt32 GetHash() const { \
        return Candera::MetaInfo::Internal::Fnv1aHash::MixHash( \
            Candera::MetaInfo::Internal::Fnv1aHash::Hash(FEATSTD_STRINGIZE(PropertyName)), \
            Candera::MetaInfo::Internal::Fnv1aHash::Hash(FEATSTD_STRINGIZE(PropertyType))); \
    }

/* Meta Information Options */

/**
 *  Internal macro - emits ctor for meta information types
 *  @param itemName name of the meta information object
 *  @param typeName type of the meta information class
 *  @param baseClass name of the meta information base class
 */
#define _CdaMetaInfoCtors(itemName, typeName, baseClass) \
    typeName() : baseClass(FEATSTD_STRINGIZE(itemName)) { }

#endif
