//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "HashFunctions.h"
#include <CanderaPlatform/OS/StringPlatform.h>

namespace Candera { namespace MetaInfo { namespace Internal {
UInt32 Fnv1aHash::Hash(const Char* string)
{
    SizeType stringLength = StringPlatform::Length(string);

    UInt32 hash = offset_basis;
    for (SizeType index = 0; index < stringLength; ++index) {
        UInt32 value = string[index];
        hash ^= value;
        hash *= FNV_prime;
    }
    return hash;
}

UInt32 Fnv1aHash::MixHash(UInt32 hash1, UInt32 hash2)
{
    return (hash1 ^ hash2) * FNV_prime;
}
}}}
