//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENERIC_INTERNAL_MACROS_H)
#define GENERIC_INTERNAL_MACROS_H

#include <Candera/System/MetaInfo/InternalMacros.h>

/*  ----------------------------------------------------------------------------
    Generic internal macros - to be merged in public macros
    ---------------------------------------------------------------------------- */

#define CdaObjectSet(type, name) \
    typedef type ObjectSetType; \
    template <> Candera::MetaInfo::ObjectMetaInfoSet<ObjectSetType>* GetObjectSet() { \
        static struct name : public Candera::MetaInfo::ObjectMetaInfoSet<ObjectSetType> { \
           _CdaMetaInfoCtors(name, name, Candera::MetaInfo::ObjectMetaInfoSet<ObjectSetType>)

#define CdaObjects() \
    _CdaAggregationProlog(Objects, Candera::MetaInfo::ObjectMetaInfo<ObjectSetType>, Candera::MetaInfo::NullAggregatable<AggregationItemBaseType>, _CdaNothing)

#define CdaObject(typeName) \
    _CdaUniqueName(Object); \
    _CdaTypedefAggregator(_CdaUniqueName(Object), _CdaAggregatable(typeName::CdaMetaInfo, AggregationItemBaseType))

#define CdaObjectsEnd() \
    _CdaAggregationEpilog(Objects, Objects) \
    _CdaMetaInfoHashInterface(Objects)

#define CdaObjectSetEnd() \
        } objectSet; \
        return &objectSet; \
    }

#define CdaObjectAbstractShareableBaseDef(type) \
    typedef type BaseTypeForMetaInfo; \
    typedef MemoryManagement::SharedPointer<type> PointerToBaseTypeForMetaInfo; \
    _CdaMetaInfoObjectBase(type) \
    _CdaMetaInfoObjectProlog(type, type, type, CdaMetaInfo, type##DefaultMetaInfo::CdaMetaInfo) \
    _CdaInheritedPropertyBase(type##DefaultMetaInfo, CdaMetaInfo)

#define CdaObjectAbstractDef(type, baseType) \
    typedef baseType::BaseTypeForMetaInfo BaseTypeForMetaInfo; \
    _CdaMetaInfoObjectProlog(type, type, BaseTypeForMetaInfo, CdaMetaInfo, baseType::CdaMetaInfo) \
    _CdaInheritedPropertyBase(baseType, CdaMetaInfo) \
    virtual Candera::MemoryManagement::SharedPointer<BaseTypeForMetaInfo> Create() { return Candera::MemoryManagement::SharedPointer<BaseTypeForMetaInfo>(); }

#define CdaObjectDef(type, baseType) \
    typedef baseType::BaseTypeForMetaInfo BaseTypeForMetaInfo; \
    _CdaMetaInfoObjectProlog(type, type, BaseTypeForMetaInfo, CdaMetaInfo, baseType::CdaMetaInfo) \
    _CdaInheritedPropertyBase(baseType, CdaMetaInfo) \
    virtual Candera::MemoryManagement::SharedPointer<BaseTypeForMetaInfo> Create() { return type::Create(); }

/**
 *  Opens a property definition section within a object definition section.
 */
#define CdaProperties() \
    _CdaPropertySetProlog(Candera::MetaInfo::PropertyMetaInfo<BaseTypeForMetaInfo>) \
    _CdaPredefinedBaseClassImportProperties(CdaMetaInfo)

#define CdaPropertyEx(name, type, getter, setter) \
    _CdaPropertyProlog(name, type) \
    typedef type PropertyType; \
    _CdaPropGetter(getter) \
    _CdaPropSetter(setter) \
    _CdaIndirectAPSFactory(name, setter, getter)

/**
 *  Closes a property definition section within a properties definition section (@see CdaPropertiesEnd)
 */
#define CdaPropertyEnd() \
    _CdaPropertyEpilog()

/**
 *  Closes a property definition section within a TransitionStrategy definition section.
 */
#define CdaPropertiesEnd() \
    _CdaPropertySetEpilog()

/**
 *  Closes a TransitionStrategy definition section
 */
#define CdaObjectDefEnd() \
    _CdaMetaInfoObjectEpilog() \
    virtual Candera::MetaInfo::ObjectMetaInfo<BaseTypeForMetaInfo>* GetMetaInfo() const { return &Candera::MetaInfo::AggregatableInstanceProvider<CdaMetaInfo>(); }

#endif
