//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EnumDataTypeInternal_h)
#define EnumDataTypeInternal_h

#include <Candera/System/MetaInfo/EnumDataTypeBase.h>
#include <Candera/System/MetaInfo/DataType.h>
/** @addtogroup MetaInfo
 * @{
 */
/**
 *  \def ENUM_DATA_TYPE
 *  \file EnumDataType.h
 *
 *  This file may be used to generate an enumeration and a Candera::MetaInfo::DataType specialization with the given
 *  enumeration, that uses the default enumeration editor builtin://EnumEditor.
 *
 *  When using this file, an enum definition is a block beginning with \a CANDERA_INTERNAL_ENUM_METAINFO_BEGIN and ending
 *  with \a CANDERA_INTERNAL_ENUM_METAINFO_END, holding at least one item defined with \a CANDERA_INTERNAL_ENUM_METAINFO_ITEM or \a CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE.
 *
 *  Example :
 *  \code
 *      CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(SomeNamespace, SomeEnum) \
 *          CANDERA_INTERNAL_ENUM_METAINFO_ITEM(SomeItem0) \
 *          CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(SomeItem1, 4) \
 *          ENUM_DATA_TYPE_ITEM(SomeItem2) \
 *      CANDERA_INTERNAL_ENUM_METAINFO_END()
 *  \endcode
 *  
 *  The DataType specialization is defined the the namespace Candera::MetaInfo.
 */

#define CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(EnumType, EnumEditorName) \
    namespace Candera { \
        namespace MetaInfo { \
            template< > \
            struct DataType< EnumType > \
            { \
                static bool ConvertToString(const EnumType val, Char *buf, UInt bufLen) { \
                    return SerializationPlatform::FromBinary(buf, bufLen, static_cast< FeatStd::Int >(val)) == 1; \
                } \
                static bool ConvertFromString(EnumType &val, const Char *buf) { \
                    Int i = 0; \
                    UInt n = SerializationPlatform::ToBinary(buf, i); \
                    val = static_cast< EnumType >(i); \
                    return n == 1; \
                } \
                static const Char* GetEditor() { \
                    return "builtin://EnumEditor?name="\
                    FEATSTD_STRINGIZE(EnumEditorName)"&values="


#define CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Item) \
                    FEATSTD_STRINGIZE(Item) ",,"

#define CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Item, Value) \
                    FEATSTD_STRINGIZE(Item) "," FEATSTD_STRINGIZE(Value)","

#define CANDERA_INTERNAL_ENUM_METAINFO_END() ; \
                } \
            }; \
        } \
    }
/** @} */
#endif
