//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(DataType_StringBufferAppender_Macros_h)
#define DataType_StringBufferAppender_Macros_h

#include <FeatStd/Util/StringBuffer.h>

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
#define CdaDeclareStringBufferAppender(type) \
    namespace FeatStd { \
        template<> UInt32 StringBufferAppender<type>::Append(StringBuffer& stringBuffer, type const & object); \
    } 

#define CdaDefineStringBufferAppender(type) \
    namespace FeatStd { \
        template<> UInt32 StringBufferAppender<type>::Append(StringBuffer& stringBuffer, type const & object) \
        { \
            UInt32 tcharCount = 0; \
            Char buffer[FEATSTD_STRINGBUFFER_APPENDER_CANDERATYPESIZE]; \
            /* ConvertToString returns false if buffer is not empty */ \
            if (!Candera::MetaInfo::Internal::DataType<type>::ConvertToString(object, buffer, FEATSTD_STRINGBUFFER_APPENDER_CANDERATYPESIZE)) { \
                tcharCount += stringBuffer.Append(buffer); \
            } \
            return tcharCount; \
        } \
    } 

#else
#define CdaDeclareStringBufferAppender(type)
#define CdaDefineStringBufferAppender(type)
#endif

#endif // DataType_StringBufferAppender_Macros_h
